package com.bcxin.tenant.open.rest.apis.controllers.responses;

import com.bcxin.tenant.open.infrastructures.enums.PoliceEventCategory;
import com.bcxin.tenant.open.infrastructures.utils.PoliceEventCategoryUtils;
import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Getter
public class PoliceIncidentOverviewResponse extends ResponseAbstract {
    @Schema(name = "id", title = "id")
    private final String id;
    @Schema(name = "actionTime", title = "操作时间")
    private final String actionTime;
    @Schema(name = "actionType", title = "操作类型")
    private final String actionType;
    @Schema(name = "address", title = "操作地址")
    private final String address;
    @Schema(name = "name", title = "姓名")
    private final String name;
    @Schema(name = "idNumber", title = "身份证")
    private final String idNumber;
    @Schema(name = "companyId", title = "企业Id")
    private final String companyId;
    @Schema(name = "companyName", title = "企业名称")
    private final String companyName;
    @Schema(name = "securityStationId", title = "驻勤点Id")
    private final String securityStationId;
    @Schema(name = "securityStationName", title = "驻勤点名称")
    private final String securityStationName;
    @Schema(name = "superviseDepartId", title = "监管归属Id")
    private final String superviseDepartId;
    @Schema(name = "superviseDepartName", title = "监管归属名称")
    private final String superviseDepartName;
    @Schema(name = "note", title = "备注")
    private final String note;



    public PoliceIncidentOverviewResponse(String id, String actionTime,
                                          PoliceEventCategory category,
                                          int actionType,
                                          String address, String name, String idNumber,
                                          String companyId, String companyName, String securityStationId,
                                          String securityStationName,
                                          String superviseDepartId, String superviseDepartName, String note) {
        this.id = id;
        this.actionTime = actionTime;
        this.actionType = PoliceEventCategoryUtils.getEventTypeName(category,actionType);
        this.address = address;
        this.name = name;
        this.idNumber = idNumber;
        this.companyId = companyId;
        this.companyName = companyName;
        this.securityStationId = securityStationId;
        this.securityStationName = securityStationName;
        this.superviseDepartId = superviseDepartId;
        this.superviseDepartName = superviseDepartName;
        this.note = note;
    }

    public static PoliceIncidentOverviewResponse create(String id, String actionTime,              PoliceEventCategory category,
                                                        int actionType,
                                                        String address, String name, String idNumber,
                                                        String companyId, String companyName, String securityStationId,
                                                        String securityStationName,
                                                        String superviseDepartId, String superviseDepartName, String note) {
        return new PoliceIncidentOverviewResponse(
                id, actionTime, category, actionType, address, name, idNumber,
                companyId, companyName, securityStationId, securityStationName, superviseDepartId, superviseDepartName, note
        );
    }
}
