package com.bcxin.tenant.open.rest.apis.controllers.responses;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Getter
public class MyAttendanceRecordResponse extends ResponseAbstract {
    @ExcelProperty("操作时间")
    @Schema(name = "operatorTime", title = "操作时间")
    private final String operatorTime;

    @ExcelProperty("操作类型")
    @Schema(name = "operatorType", title = "操作类型")
    private final String operatorType;

    @ExcelProperty("姓名")
    @Schema(name = "name", title = "姓名")
    private final String name;

    @ExcelIgnore
    @Schema(name = "operatorAddress", title = "操作地点")
    private final String operatorAddress;

    public MyAttendanceRecordResponse(String operatorTime, String operatorType, String name, String operatorAddress) {
        this.operatorTime = operatorTime;
        this.operatorType = operatorType;
        this.name = name;
        this.operatorAddress = operatorAddress;
    }

    public static MyAttendanceRecordResponse create(String operatorTime, String operatorType, String name, String operatorAddress) {
        return new MyAttendanceRecordResponse(operatorTime, operatorType, name, operatorAddress);
    }
}
