package com.bcxin.tenant.open.rest.apis.controllers.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Getter
public class DispatchResponse extends ResponseAbstract {
    @Schema(name = "dispatchToken", title = "身份Token")
    private final String dispatchToken;

    @Schema(name = "supervise", title = "是否监管身份")
    private final boolean supervise;

    @Schema(name = "regionCode", title = "系统所在区域; 晋城为1405")
    private final String regionCode;

    public DispatchResponse(String dispatchToken, boolean supervise, String regionCode) {

        this.dispatchToken = dispatchToken;
        this.supervise = supervise;
        this.regionCode = regionCode;
    }

    public static DispatchResponse create(String dispatchToken,boolean supervise, String regionCode) {
        return new DispatchResponse(dispatchToken,supervise, regionCode);
    }
}
