package com.bcxin.tenant.open.rest.apis.controllers.requests;

import com.bcxin.tenant.open.infrastructures.enums.RecordStatus;
import com.bcxin.tenant.open.infrastructures.enums.ReferenceType;
import com.bcxin.tenant.open.infrastructures.models.AgentHeaderOptionValue;
import com.bcxin.tenant.open.jdks.requests.RequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Schema(name = "AttendanceValidationRestRequest",title = "签到前的验证信息")
@Data
public class AttendanceValidationRestRequest extends RequestAbstract {
    @Schema(name = "recordStatus", title = "状态：SignIn 签到，SignOut 签退")
    private RecordStatus recordStatus;

    @Schema(name = "referenceType", title = "类型：Comon 普通，Station 驻勤点, JobStation 任务信息")
    private ReferenceType referenceType;

    @Schema(name = "note", title = "备注")
    private String note;

    @Schema(name = "address", title = "地址")
    private String address;

    @Schema(name = "latitude", title = "维度 y")
    private double latitude;

    @Schema(name = "longitude", title = "经度 x")
    private double longitude;
}
