package com.bcxin.tenant.open.rest.apis.controllers;

import com.bcxin.tenant.open.jdks.UserWriterRpcProvider;
import com.bcxin.tenant.open.jdks.responses.UserPurseResponse;
import com.bcxin.tenant.open.rest.apis.utils.JwtUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

@Tag(name = "UserController", description = "临保项目")
@RestController
@RequestMapping("/users")
public class UserController extends ControllerAbstract{

    private final UserWriterRpcProvider userWriterRpcProvider;

    public UserController(UserWriterRpcProvider userWriterRpcProvider) {
        this.userWriterRpcProvider = userWriterRpcProvider;
    }

    @Operation(
            summary = "获取指定用户的积分", description = "获取指定用户的积分",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回调度系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = false,
                            name = "accessToken", description = "来自V5的accessToken")
            }
    )
    @GetMapping("/{tenantUserId}/purse")
    public ResponseEntity<UserPurseResponse> getUserPurseResponse(@PathVariable String tenantUserId,
                                                                  @RequestHeader("accessToken") String accessToken) {
        String employeeId = JwtUtil.getUserIdFromToken(accessToken);

        if (!StringUtils.hasLength(employeeId)) {
            return this.status(HttpStatus.UNAUTHORIZED, "未授权用户");
        }

        UserPurseResponse purseResponse =
                this.userWriterRpcProvider.getById(tenantUserId);

        return this.ok(purseResponse);
    }
}
