package com.bcxin.tenant.open.rest.apis.controllers;

import com.bcxin.tenant.open.jdks.StationDeviceRpcProvider;
import com.bcxin.tenant.open.jdks.requests.StationDeviceSearchRequest;
import com.bcxin.tenant.open.jdks.responses.StationDeviceResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;

@Tag(name = "StationDeviceController", description = "点位设备信息")
@RestController
@RequestMapping("/station-devices")
public class StationDeviceController extends ControllerAbstract{

    private final StationDeviceRpcProvider stationDeviceRpcProvider;

    public StationDeviceController(StationDeviceRpcProvider stationDeviceRpcProvider) {
        this.stationDeviceRpcProvider = stationDeviceRpcProvider;
    }

    @Operation(summary = "搜索考场/驻勤点/岗点的设备信息", description = "搜索考场/驻勤点/岗点的设备信息; 只返回集合数据不返回总行数",
            requestBody =
            @io.swagger.v3.oas.annotations.parameters.RequestBody(
                    required = true),
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回考场列表")
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken")
            }
    )
    @PostMapping("/search")
    public ResponseEntity<Collection<StationDeviceResponse>> post(@RequestBody StationDeviceSearchRequest request) {
        Collection<StationDeviceResponse> data =
                this.stationDeviceRpcProvider.search(request);

        return this.ok(data);
    }
}
