package com.bcxin.tenant.open.rest.apis.controllers;

import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.jdks.RollCallEmployeeReaderRpcProvider;
import com.bcxin.tenant.open.jdks.requests.RollCallEmployeeGroupSearchRequest;
import com.bcxin.tenant.open.jdks.requests.RollCallEmployeeSearchRequest;
import com.bcxin.tenant.open.jdks.responses.RollCallEmployeeGroupSearchResponse;
import com.bcxin.tenant.open.jdks.responses.RollCallEmployeeSearchResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;

@Tag(name = "RollCallEmployeeController", description = "点名轮询/督导点名查询")
@RestController
@RequestMapping("/roll-call-employees")
public class RollCallEmployeeController extends ControllerAbstract{
    private final RollCallEmployeeReaderRpcProvider rollCallEmployeeReaderRpcProvider;

    public RollCallEmployeeController(RollCallEmployeeReaderRpcProvider rollCallEmployeeReaderRpcProvider) {
        this.rollCallEmployeeReaderRpcProvider = rollCallEmployeeReaderRpcProvider;
    }

    @Operation(
            summary = "group-search", description = "搜索点名轮换和督导点名分组数据",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回调度系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken")
            }
    )
    @PostMapping("/group-search")
    public ResponseEntity<EntityCollection<RollCallEmployeeGroupSearchResponse>> search(@RequestBody RollCallEmployeeGroupSearchRequest request) {
        EntityCollection<RollCallEmployeeGroupSearchResponse> data =
                this.rollCallEmployeeReaderRpcProvider.search(request);

        return this.ok(data);
    }


    @Operation(
            summary = "search", description = "APP端中查看我的点名记录或者WEB端查看点名/督导的详情人员列表",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回调度系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken")
            }
    )
    @PostMapping("/search")
    public ResponseEntity<Collection<RollCallEmployeeSearchResponse>> search(@RequestBody RollCallEmployeeSearchRequest request) {
        Collection<RollCallEmployeeSearchResponse> data =
                this.rollCallEmployeeReaderRpcProvider.search(request);

        return this.ok(data);
    }
}
