package com.bcxin.tenant.open.rest.apis.controllers;

import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.jdks.ProjectTeamMemberRpcProvider;
import com.bcxin.tenant.open.jdks.requests.ProjectTeamMemberSearchRequest;
import com.bcxin.tenant.open.jdks.responses.ProjectTeamMemberResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

@Tag(name = "ProjectController", description = "临保项目")
@RestController
@RequestMapping("/project-team-members")
public class ProjectTeamMemberController extends ControllerAbstract {
    private final ProjectTeamMemberRpcProvider projectTeamMemberRpcProvider;
    public ProjectTeamMemberController(ProjectTeamMemberRpcProvider projectTeamMemberRpcProvider) {
        this.projectTeamMemberRpcProvider = projectTeamMemberRpcProvider;
    }


    @Operation(summary = "临保项目人员", description = "临保项目人员; 只返回集合数据不返回总行数",
            requestBody =
            @io.swagger.v3.oas.annotations.parameters.RequestBody(
                    required = true),
            responses = {
                    @ApiResponse(responseCode = "200", description = "临保项目人员")
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken")
            }
    )
    @PostMapping("/search")
    public ResponseEntity<EntityCollection<ProjectTeamMemberResponse>> post(@RequestBody ProjectTeamMemberSearchRequest request) {
        EntityCollection<ProjectTeamMemberResponse> data =
                this.projectTeamMemberRpcProvider.search(request);

        return this.ok(data);
    }
}
