package com.bcxin.tenant.open.rest.apis.controllers;

import com.bcxin.tenant.open.jdks.ExamSiteRoomReaderRpcProvider;
import com.bcxin.tenant.open.jdks.requests.ExamSiteRoomSearchRequest;
import com.bcxin.tenant.open.jdks.responses.ExamSiteRoomDetailResponse;
import com.bcxin.tenant.open.jdks.responses.ExamSiteRoomOverviewResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;

@Tag(name = "ExamSiteRoomController", description = "考试点考场信息查询")
@RestController
@RequestMapping("/exam-site-rooms")
public class ExamSiteRoomController extends ControllerAbstract{
    private static final Logger logger = LoggerFactory.getLogger(ExamSiteRoomController.class);
    private final ExamSiteRoomReaderRpcProvider examSiteRoomReaderRpcProvider;

    public ExamSiteRoomController(ExamSiteRoomReaderRpcProvider examSiteRoomReaderRpcProvider) {
        this.examSiteRoomReaderRpcProvider = examSiteRoomReaderRpcProvider;
    }

    @Operation(summary = "搜索考场", description = "搜索考场; 只返回集合数据不返回总行数",
            requestBody =
            @io.swagger.v3.oas.annotations.parameters.RequestBody(
                    required = true),
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回考场列表")
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken")
            }
    )
    @PostMapping("/search")
    public ResponseEntity<Collection<ExamSiteRoomOverviewResponse>> post(@RequestBody ExamSiteRoomSearchRequest request) {
        Collection<ExamSiteRoomOverviewResponse> data =
                this.examSiteRoomReaderRpcProvider.search(request);

        return this.ok(data);
    }

    @Operation(summary = "考场详情", description = "返回考场详情",
            requestBody =
            @io.swagger.v3.oas.annotations.parameters.RequestBody(
                    required = true),
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回考场详情")
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken")
            }
    )
    @PostMapping("/{id}")
    public ResponseEntity<ExamSiteRoomDetailResponse> get(@PathVariable String id) {
        ExamSiteRoomDetailResponse data = this.examSiteRoomReaderRpcProvider.get(id);

        return this.ok(data);
    }
}
