package com.bcxin.tenant.open.rest.apis.controllers;

import com.bcxin.tenant.open.jdks.ExamSiteReaderRpcProvider;
import com.bcxin.tenant.open.jdks.responses.ExamSiteResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@Tag(name = "ExamSiteController", description = "考试点信息查询")
@RestController
@RequestMapping("/exam-sites")
public class ExamSiteController  extends ControllerAbstract{
    private final ExamSiteReaderRpcProvider examSiteReaderRpcProvider;

    public ExamSiteController(ExamSiteReaderRpcProvider examSiteReaderRpcProvider) {
        this.examSiteReaderRpcProvider = examSiteReaderRpcProvider;
    }

    @Operation(summary = "考试点详情", description = "返回考试点详情",
            requestBody =
            @io.swagger.v3.oas.annotations.parameters.RequestBody(
                    required = true),
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回考场详情")
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken")
            }
    )
    @GetMapping("/{id}")
    public ResponseEntity<ExamSiteResponse> get(@PathVariable String id) {
        ExamSiteResponse data = this.examSiteReaderRpcProvider.get(id);

        return this.ok(data);
    }
}
