package com.bcxin.tenant.open.rest.apis.controllers;
import com.bcxin.tenant.open.infrastructures.TenantContext;
import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.jdks.DepartmentlevelRpcProvider;
import com.bcxin.tenant.open.jdks.requests.DepartmentSearchRequest;
import com.bcxin.tenant.open.jdks.responses.DepartmentlevelHierarchyResponse;
import com.bcxin.tenant.open.rest.apis.caches.CacheKeyManage;
import com.bcxin.tenant.open.rest.apis.caches.DepartmentlevelHierarchyResponseWrapper;
import com.bcxin.tenant.open.rest.apis.components.HotCacheProvider;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;

@Tag(name = "DepartmentlevelController", description = "监管机构查询")
@RestController
@RequestMapping("/departs")
public class DepartmentlevelController extends ControllerAbstract {
    private final DepartmentlevelRpcProvider departmentlevelRpcProvider;
    private final HotCacheProvider hotCacheProvider;

    public DepartmentlevelController(DepartmentlevelRpcProvider departmentlevelRpcProvider, HotCacheProvider hotCacheProvider) {
        this.departmentlevelRpcProvider = departmentlevelRpcProvider;
        this.hotCacheProvider = hotCacheProvider;
    }

    @Operation(summary = "递归监管机构", description = "根据当前用户所在省查询递归监管机构",
            requestBody =
            @io.swagger.v3.oas.annotations.parameters.RequestBody(
                    required = true),
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回监管部门列表")
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken")
            }
    )
    @PostMapping("/searchDeparts")
    @Deprecated
    public ResponseEntity<Collection<DepartmentlevelHierarchyResponse>> searchDeparts() {
        Collection<DepartmentlevelHierarchyResponse> data = this.departmentlevelRpcProvider.search(new DepartmentSearchRequest());
        
        return this.ok(data);
    }

    @Operation(summary = "递归监管机构", description = "根据当前用户所在省查询递归监管机构",
            requestBody =
            @io.swagger.v3.oas.annotations.parameters.RequestBody(
                    required = true),
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回监管部门列表")
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken")
            }
    )
    @PostMapping("/search")
    public ResponseEntity<Collection<DepartmentlevelHierarchyResponse>> search(@RequestBody DepartmentSearchRequest request) {
        Collection<DepartmentlevelHierarchyResponse> data =
                this.departmentlevelRpcProvider.search(request);

        return this.ok(data);
    }
}