package com.bcxin.tenant.open.rest.apis.controllers;

import com.bcxin.tenant.open.jdks.CacheWriterProvider;
import com.bcxin.tenant.open.rest.apis.components.HotCacheProvider;
import com.bcxin.tenant.open.rest.apis.controllers.requests.CleanCacheRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@Tag(name="CacheController", description = "获取及清除缓存信息")
@RestController
@RequestMapping("/caches")
public class CacheController extends ControllerAbstract {
    private final HotCacheProvider hotCacheProvider;
    private final CacheWriterProvider cacheWriterProvider;

    public CacheController(HotCacheProvider hotCacheProvider, CacheWriterProvider cacheWriterProvider) {
        this.hotCacheProvider = hotCacheProvider;
        this.cacheWriterProvider = cacheWriterProvider;
    }

    @Operation(
            description = "post: ",
            responses = {
                    @ApiResponse(responseCode = "200", description = "成功返回ok.")
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken")
            }
    )
    @PostMapping("/search")
    public ResponseEntity post() {
        var data = this.hotCacheProvider.getAllLocalCaches();
        var writerCacheKeys = this.cacheWriterProvider.getAllKeys();

        data.put("writer:cache",writerCacheKeys);
        return this.ok(data);
    }

    @Operation(
            description = "删除缓存信息",
            responses = {
                    @ApiResponse(responseCode = "200", description = "成功返回ok.")
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken")
            }
    )
    @PostMapping("/delete")
    public ResponseEntity clearCache(@RequestBody CleanCacheRequest request) {
        this.hotCacheProvider.delete(request.getKeys());
        this.cacheWriterProvider.delete(request.getKeys());
        return this.ok();
    }

    @Operation(
            description = "获取key对应的缓存信息: ",
            responses = {
                    @ApiResponse(responseCode = "200", description = "成功返回ok.")
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken")
            }
    )
    @GetMapping("/{key}")
    public ResponseEntity get(@PathVariable String key) {
        Map<String,Object> cacheValues = new HashMap<>();
        Object data = this.hotCacheProvider.get(key,Object.class);
        Object second = this.cacheWriterProvider.get(key);

        cacheValues.put("hotCache",data);
        cacheValues.put("writer:cache",second);

        return this.ok(cacheValues);
    }
}
