package com.bcxin.tenant.open.rest.apis.controllers;

import com.bcxin.tenant.open.jdks.AnalyticsLogRpcProvider;
import com.bcxin.tenant.open.jdks.requests.AnalyticsLogCreateRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="AnalyticsLogController", description = "操作记录接口")
@RestController
@RequestMapping("/analytics")
public class AnalyticsLogController extends ControllerAbstract {
    public final AnalyticsLogRpcProvider analyticsLogRpcProvider;

    public AnalyticsLogController(AnalyticsLogRpcProvider analyticsLogRpcProvider) {
        this.analyticsLogRpcProvider = analyticsLogRpcProvider;
    }

    @Operation(summary = "添加操作记录",description = "添加不同的类型的操作记录，如查询保安员轨迹记录、电子围栏查询记录",
            parameters = {@Parameter(name = "dispatchToken", in = ParameterIn.HEADER, required = true,
                    description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken")},
             requestBody = @io.swagger.v3.oas.annotations.parameters.RequestBody(required = true,
                     content = @Content(mediaType = "application/json")),
            responses = {@ApiResponse(responseCode = "200",description = "成功返回ok")}
    )
    @PostMapping
    public ResponseEntity post(@RequestBody AnalyticsLogCreateRequest request){
        this.analyticsLogRpcProvider.create(request);
        return this.ok();
    }
}
