package com.bcxin.tenant.open.rest.apis.configs;

import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

/**
 * Websocket
 * https://www.baeldung.com/websockets-spring
 */
@Configuration
@EnableWebSocketMessageBroker
public class WebSocketConfig implements WebSocketMessageBrokerConfigurer {

    /**
     * 这个方法的配置跟contex-path无关
     * @param registry
     */
    @Override
    public void configureMessageBroker(MessageBrokerRegistry registry) {
        WebSocketMessageBrokerConfigurer.super.configureMessageBroker(registry);
        registry.enableSimpleBroker("/dispatch/websocket/topic");
        /**
         * 配置stompClient.send("/dispatch/websocket/app/chat", {}, JSON.stringify({'from': from, 'text': text}));
         * 这个的前缀后加MessageController来实现MessageController这个效果
         *
         *
         * */
        registry.setApplicationDestinationPrefixes("/app");
    }

    @Override
    public void registerStompEndpoints(StompEndpointRegistry registry) {
        WebSocketMessageBrokerConfigurer.super.registerStompEndpoints(registry);

        /**
         * 连接的时候用到
         * 调用的时候需要加上content-path: 也就是/dispatch/alive-connect
         * 对应: 			var socket = new SockJS('/dispatch/alive-connect');
         * 的连接
         */
        registry.addEndpoint("/alive-connect");
        registry.addEndpoint("/alive-connect").withSockJS();
    }
}
