package com.bcxin.tenant.open.rest.apis.components;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public interface HotCacheProvider {
    <T> T get(String key, Supplier<T> supplier, int cacheInSeconds, Class<T> tClass, boolean enableLocalCache);

    <T> T get(String key, Class<T> tClass);

    <T> void put(String key, int cacheInSeconds, T data, boolean enableLocalCache);

    void delete(String key);

    void delete(Collection<String> keys);

    <T> T getFromLocal(String key, Supplier<T> supplier, int cacheInSeconds, Class<T> tClass);

    Map<String,Object> getAllLocalCaches();
}


