package com.bcxin.tenant.open.rest.apis.caches;

import com.alibaba.fastjson.annotation.JSONField;
import com.bcxin.tenant.open.infrastructures.enums.DispatchAccountType;
import com.bcxin.tenant.open.infrastructures.enums.OccupationType;
import lombok.Data;

import java.util.List;
import java.util.Set;

@Data
public class UserDetailCache extends CacheAbstract{
    private String id;
    @JSONField(name = "eid")
    private String employeeId;

    @JSONField(name = "name")
    private String name;
    @JSONField(name = "orId")
    private String organizationId;

    @JSONField(name = "ocType")
    private OccupationType occupationType;

    @JSONField(name = "imIdentity")
    private String imIdentity;

    @JSONField(name = "org_lat")
    private Double orgLatitude;

    @JSONField(name = "org_lon")
    private Double orgLongitude;

    @JSONField(name = "supervise")
    private Boolean supervise;

    @JSONField(name = "org_ist")
    private String institutional;

    @JSONField(name = "org_name")
    private String orgName;

    @JSONField(name = "domain_admin")
    private boolean domainAdmin;

    @JSONField(name = "res_sids")
    private Set<String> responsibleOfStationIds;

    @JSONField(name = "sids")
    private List<String> selectedStationIds;

    @JSONField(name = "sup_region_code")
    private String superviseRegionCode;

    /**
     * 所在企业的级别:(企业或者集团等等)
     */
    @JSONField(name = "cLevel")
    private int cLevel;

    @JSONField(name = "rts")
    private Set<String> rts;

    /**
     * 支付企业Id
     */
    @JSONField(name = "pOrgId")
    private String paymentOrgId;

    public UserDetailCache() {
        this.supervise = false;
    }

    public UserDetailCache(String id, String employeeId, String name,
                              String organizationId,
                              OccupationType occupationType,
                              String imIdentity,
                              String institutional,
                              String superviseRegionCode,
                              String orgName,
                              boolean domainAdmin,
                              Set<String> responsibleOfStationIds,
                              List<String> selectedStationIds,
                              int cLevel,
                              Set<String> rts,
                           Double orgLatitude, Double orgLongitude,
                           Boolean supervise,
                           String paymentOrgId) {
        this.id = id;
        this.employeeId = employeeId;
        this.name = name;
        this.organizationId = organizationId;
        this.occupationType = occupationType;
        this.imIdentity = imIdentity;
        this.institutional = institutional;
        this.superviseRegionCode = superviseRegionCode;
        this.orgName = orgName;
        this.domainAdmin = domainAdmin;
        this.responsibleOfStationIds = responsibleOfStationIds;
        this.selectedStationIds = selectedStationIds;
        this.cLevel = cLevel;
        this.rts = rts;
        this.orgLatitude = orgLatitude;
        this.orgLongitude = orgLongitude;
        this.supervise = supervise;
        this.paymentOrgId = paymentOrgId;
    }

    public static UserDetailCache create(String id,
                                            String employeeId, String name,
                                            String organizationId,
                                            OccupationType occupationType,
                                            String imIdentity,
                                            String institutional,
                                            String superviseRegionCode,
                                            String orgName,
                                            boolean domainAdmin,
                                            Set<String> responsibleOfStationIds,
                                            List<String> selectedStationIds,
                                            int cLevel,
                                            Set<String> rts,
                                         Double orgLatitude, Double orgLongitude,
                                         Boolean supervise,
                                         String paymentOrgId) {
        return new UserDetailCache(
                id, employeeId, name,
                organizationId,
                occupationType,
                imIdentity,
                institutional,
                superviseRegionCode,
                orgName, domainAdmin, responsibleOfStationIds,
                selectedStationIds, cLevel,rts,orgLatitude,orgLongitude,
                supervise,paymentOrgId);
    }
}
