/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.views;

import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.PointChangeType;
import com.bcxin.tenant.open.infrastructures.exceptions.NotSupportTenantException;
import java.util.Map;

public class TencentCallbackLogView
extends EntityAbstract
implements Aggregate {
    private Long id;
    private Long eventGroupId;
    private Long callbackTs;
    private Long eventType;
    private String tencentUserId;
    private String roomId;
    private String eventInfo;

    public Long getEventMsTs(JsonProvider jsonProvider) {
        if (this.getEventInfo() == null || this.getEventInfo() == "") {
            return -1L;
        }
        Map mapValue = (Map)jsonProvider.toObject(Map.class, this.getEventInfo());
        if (mapValue == null || !mapValue.containsKey("EventMsTs")) {
            return -1L;
        }
        Long eventTs = Long.parseLong(mapValue.get("EventMsTs").toString());
        return eventTs;
    }

    public PointChangeType getChangeType() {
        if (this.getEventType() == 203L || this.getEventType() == 204L) {
            return PointChangeType.AudioCost;
        }
        if (this.getEventType() == 201L || this.getEventType() == 202L) {
            return PointChangeType.VideoCost;
        }
        if (this.getEventType() == 205L || this.getEventType() == 206L) {
            return PointChangeType.AuxiliaryData;
        }
        throw new NotSupportTenantException(String.format("\u4e0d\u652f\u6301\u8be5\u7c7b\u578b:%s", this.getEventType()));
    }

    public Long getId() {
        return this.id;
    }

    public Long getEventGroupId() {
        return this.eventGroupId;
    }

    public Long getCallbackTs() {
        return this.callbackTs;
    }

    public Long getEventType() {
        return this.eventType;
    }

    public String getTencentUserId() {
        return this.tencentUserId;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public String getEventInfo() {
        return this.eventInfo;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setEventGroupId(Long eventGroupId) {
        this.eventGroupId = eventGroupId;
    }

    public void setCallbackTs(Long callbackTs) {
        this.callbackTs = callbackTs;
    }

    public void setEventType(Long eventType) {
        this.eventType = eventType;
    }

    public void setTencentUserId(String tencentUserId) {
        this.tencentUserId = tencentUserId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public void setEventInfo(String eventInfo) {
        this.eventInfo = eventInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TencentCallbackLogView)) {
            return false;
        }
        TencentCallbackLogView other = (TencentCallbackLogView)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$eventGroupId = this.getEventGroupId();
        Long other$eventGroupId = other.getEventGroupId();
        if (this$eventGroupId == null ? other$eventGroupId != null : !((Object)this$eventGroupId).equals(other$eventGroupId)) {
            return false;
        }
        Long this$callbackTs = this.getCallbackTs();
        Long other$callbackTs = other.getCallbackTs();
        if (this$callbackTs == null ? other$callbackTs != null : !((Object)this$callbackTs).equals(other$callbackTs)) {
            return false;
        }
        Long this$eventType = this.getEventType();
        Long other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !((Object)this$eventType).equals(other$eventType)) {
            return false;
        }
        String this$tencentUserId = this.getTencentUserId();
        String other$tencentUserId = other.getTencentUserId();
        if (this$tencentUserId == null ? other$tencentUserId != null : !this$tencentUserId.equals(other$tencentUserId)) {
            return false;
        }
        String this$roomId = this.getRoomId();
        String other$roomId = other.getRoomId();
        if (this$roomId == null ? other$roomId != null : !this$roomId.equals(other$roomId)) {
            return false;
        }
        String this$eventInfo = this.getEventInfo();
        String other$eventInfo = other.getEventInfo();
        return !(this$eventInfo == null ? other$eventInfo != null : !this$eventInfo.equals(other$eventInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TencentCallbackLogView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $eventGroupId = this.getEventGroupId();
        result = result * 59 + ($eventGroupId == null ? 43 : ((Object)$eventGroupId).hashCode());
        Long $callbackTs = this.getCallbackTs();
        result = result * 59 + ($callbackTs == null ? 43 : ((Object)$callbackTs).hashCode());
        Long $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : ((Object)$eventType).hashCode());
        String $tencentUserId = this.getTencentUserId();
        result = result * 59 + ($tencentUserId == null ? 43 : $tencentUserId.hashCode());
        String $roomId = this.getRoomId();
        result = result * 59 + ($roomId == null ? 43 : $roomId.hashCode());
        String $eventInfo = this.getEventInfo();
        result = result * 59 + ($eventInfo == null ? 43 : $eventInfo.hashCode());
        return result;
    }

    public String toString() {
        return "TencentCallbackLogView(id=" + this.getId() + ", eventGroupId=" + this.getEventGroupId() + ", callbackTs=" + this.getCallbackTs() + ", eventType=" + this.getEventType() + ", tencentUserId=" + this.getTencentUserId() + ", roomId=" + this.getRoomId() + ", eventInfo=" + this.getEventInfo() + ")";
    }
}

