/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains;

import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class BillPaymentRuleConfig {
    private final Collection<String> paidByCallerRegionExpressions;
    private final boolean ignoredCalledPoints;

    public BillPaymentRuleConfig(Collection<String> paidByCallerRegionExpressions, boolean ignoredCalledPoints) {
        this.paidByCallerRegionExpressions = paidByCallerRegionExpressions;
        this.ignoredCalledPoints = ignoredCalledPoints;
    }

    public boolean isPaymentOwner(String sponsorOrgInstitutional, String sponsorSuperviseRegionCode) {
        if (BusinessUtil.isProprietor((String)sponsorOrgInstitutional) || BusinessUtil.isEventSponsor((String)sponsorOrgInstitutional)) {
            return true;
        }
        if (BusinessUtil.isSupervise((String)sponsorOrgInstitutional) && !CollectionUtils.isEmpty(this.getPaidByCallerRegionExpressions())) {
            boolean matched = this.getPaidByCallerRegionExpressions().stream().anyMatch(ii -> sponsorSuperviseRegionCode.startsWith((String)ii));
            return matched;
        }
        return false;
    }

    public boolean isPaymentOwner(String sponsorOrgId, String sponsorOrgInstitutional, String sponsorSuperviseRegionCode) {
        return this.isPaymentOwner(sponsorOrgInstitutional, sponsorSuperviseRegionCode);
    }

    public boolean ignoreCheckUserPoints(boolean paymentOwner) {
        return this.isIgnoredCalledPoints();
    }

    private Collection<String> getPaidByCallerRegionExpressions() {
        return this.paidByCallerRegionExpressions;
    }

    private boolean isIgnoredCalledPoints() {
        return this.ignoredCalledPoints;
    }
}

