/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.utils;

import com.bcxin.tenant.open.document.domains.documents.RdCompanyDocument;
import com.bcxin.tenant.open.document.domains.documents.RdDispatchDataScopeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument$;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument;
import com.bcxin.tenant.open.document.domains.repositories.RdSecurityStationDocumentRepository;
import com.bcxin.tenant.open.document.domains.utils.GeoPointUtils;
import com.bcxin.tenant.open.domains.entities.RdSecurityStationEntity;
import com.bcxin.tenant.open.domains.entities.StationDeviceEntity;
import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.SearchStream;
import com.redis.om.spring.search.stream.predicates.SearchFieldPredicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RdSecurityStationEntityUtil
implements BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(RdSecurityStationEntityUtil.class);
    private static BeanFactory beanFactory;

    public static RdSecurityStationDocument toDocument(RdSecurityStationEntity ii, boolean isFromSync, RdSecurityStationDocumentRepository securityStationDocumentRepository, EntityStream entityStream, Collection<RdDispatchDataScopeDocument> dataScopeDocuments, Collection<RdCompanyDocument> proprietorCompanyDocuments, Collection<StationDeviceEntity> stationDevices) {
        try {
            Collection scopeIds;
            Optional securityStationDocumentOptional;
            RdSecurityStationDocument document = null;
            if (!isFromSync && (securityStationDocumentOptional = securityStationDocumentRepository.findById((Object)ii.getId())).isPresent()) {
                document = (RdSecurityStationDocument)securityStationDocumentOptional.get();
            }
            if (document == null) {
                document = new RdSecurityStationDocument();
                document.setId(ii.getId());
            }
            document.rest();
            StringBuilder countOfSec = new StringBuilder();
            countOfSec.append(String.format("org.countOfSecurityMan=%s;", ii.getCountOfSecurityMan()));
            document.setCountOfSecurityMan(Integer.valueOf(ii.getCountOfSecurityMan()));
            document.setName(ii.getName());
            document.setAddress(ii.getAddress());
            document.setOrganizationId(ii.getOrganizationId());
            document.setCompanyName(ii.getCompanyName());
            if (StringUtils.hasLength((String)ii.getStationType())) {
                document.setStationTypes(Arrays.stream(ii.getStationType().split(",")).collect(Collectors.toSet()));
            } else {
                document.setStationTypes(new HashSet());
            }
            document.setPrincipalId(ii.getPrincipalId());
            document.setPrincipalName(ii.getPrincipalName());
            document.setPrincipalContact(ii.getPrincipalContact());
            document.addScopePermissions(new String[]{ii.getOrganizationId()});
            document.setSuperviseDepartId(ii.getSuperviseDepartId());
            document.addScopePermissions(new String[]{ii.getSuperviseDepartId()});
            document.setSuperviseDepartName(ii.getSuperviseDepartName());
            if (!CollectionUtils.isEmpty(dataScopeDocuments) && !CollectionUtils.isEmpty((Collection)(scopeIds = (Collection)dataScopeDocuments.stream().filter(it -> StringUtil.isEqual((String)it.getId(), (String)ii.getId()) && !CollectionUtils.isEmpty((Collection)it.getScopes())).flatMap(it -> it.getScopes().stream()).distinct().collect(Collectors.toList())))) {
                Collection perCompanies;
                document.addScopePermissions((String[])scopeIds.toArray(String[]::new));
                if (!CollectionUtils.isEmpty(proprietorCompanyDocuments) && !CollectionUtils.isEmpty((Collection)(perCompanies = (Collection)proprietorCompanyDocuments.stream().filter(it -> scopeIds.contains(it.getId())).collect(Collectors.toList())))) {
                    document.addScopePermissions((String[])perCompanies.stream().map(ix -> ix.getSuperviseDepartId()).filter(ix -> !StringUtil.isEmpty((String)ix)).collect(Collectors.toList()).toArray(String[]::new));
                    RdCompanyDocument firstCom = (RdCompanyDocument)perCompanies.stream().findFirst().get();
                    document.assignProprietor(firstCom.getId(), firstCom.getName());
                    document.addResourceTypes(new String[]{ResourceType.ProprietorManaged.name()});
                }
            }
            document.setServiceScope(ii.getServiceScope());
            document.setLonLat(GeoPointUtils.translate((String)ii.getLonLat()));
            document.changeState((Date)ii.getBeginDate(), (Date)ii.getEndDate(), ii.getSiteState());
            document.updateWord(new String[]{document.getName()});
            document.setIndustry(ii.getIndustry());
            document.setInstitutional(ii.getInstitutional());
            document.addResourceTypes(new String[]{ResourceType.create((String)ii.getInstitutional())});
            if (ii.getResourceType() == ResourceType.TemporarySecurity) {
                document.addResourceTypes(new String[]{ResourceType.TemporarySecurity.name()});
            }
            SearchStream searchStream = entityStream.of(RdEmployeeDocument.class);
            Collection employeeDocuments = (Collection)searchStream.filter((SearchFieldPredicate)RdEmployeeDocument$.SECURITY_STATION_ID.eq((Object)document.getId())).filter((SearchFieldPredicate)RdEmployeeDocument$.RESOURCE_TYPES.in(new String[]{ResourceType.Population.name()})).collect(Collectors.toList());
            document.updateCountOfCommunityUser((int)employeeDocuments.stream().count());
            for (RdEmployeeDocument re : employeeDocuments) {
                if (CollectionUtils.isEmpty((Collection)re.getScopePermissions())) continue;
                document.addScopePermissions((String[])re.getScopePermissions().toArray(String[]::new));
            }
            document.setLastUpdatedTime(ii.getLastSyncTime());
            if (StringUtils.hasLength((String)ii.getProjectId())) {
                document.addScopePermissions(new String[]{ii.getProjectId()});
            }
            document.setPerformRange(ii.getPerformRange());
            document.setProjectId(ii.getProjectId());
            document.setProjectName(ii.getProjectName());
            document.setHasVideo(Boolean.valueOf(false));
            if (!CollectionUtils.isEmpty(stationDevices)) {
                document.setHasVideo(Boolean.valueOf(stationDevices.stream().anyMatch(ic -> ii.getId().equalsIgnoreCase(ic.getStationId()))));
            }
            return document;
        }
        catch (Exception ex) {
            logger.error("\u9a7b\u52e4\u70b9-\u89e3\u6790\u6570\u636e\u53d1\u751f\u5f02\u5e38:id={};name={};", new Object[]{ii.getId(), ii.getName(), ex});
            return null;
        }
    }

    public void setBeanFactory(BeanFactory bf) throws BeansException {
        beanFactory = bf;
    }
}

