/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.impls;

import com.bcxin.tenant.open.domains.entities.BillStatusCheckpointEntity;
import com.bcxin.tenant.open.domains.entities.ConfigOfBillEntity;
import com.bcxin.tenant.open.domains.entities.MonthlyBillEntity;
import com.bcxin.tenant.open.domains.events.MonthlyBillGenerateEvent;
import com.bcxin.tenant.open.domains.pojo.MonthBillPojo;
import com.bcxin.tenant.open.domains.repositories.BillStatusCheckpointRepository;
import com.bcxin.tenant.open.domains.repositories.ConfigOfBillRepository;
import com.bcxin.tenant.open.domains.repositories.DailyBillRepository;
import com.bcxin.tenant.open.domains.repositories.MonthlyBillRepository;
import com.bcxin.tenant.open.domains.repositories.RdCompanyRepository;
import com.bcxin.tenant.open.domains.services.MonthlyBillService;
import com.bcxin.tenant.open.domains.services.commands.GenerateMonthlyBillCommand;
import com.bcxin.tenant.open.domains.utils.BillUtils;
import com.bcxin.tenant.open.infrastructures.UnitWork;
import com.bcxin.tenant.open.infrastructures.enums.BillType;
import com.bcxin.tenant.open.infrastructures.events.DomainEvent;
import com.bcxin.tenant.open.infrastructures.events.EventDispatcher;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MonthlyBillServiceImpl
implements MonthlyBillService {
    private static final Logger logger = LoggerFactory.getLogger(MonthlyBillServiceImpl.class);
    private final MonthlyBillRepository monthlyBillRepository;
    private final DailyBillRepository dailyBillRepository;
    private final UnitWork unitWork;
    private final ConfigOfBillRepository configOfBillRepository;
    private final RdCompanyRepository rdCompanyRepository;
    private final BillStatusCheckpointRepository billStatusCheckpointRepository;
    private final EventDispatcher eventDispatcher;
    private static final int BATCH_SIZE = 100;

    public MonthlyBillServiceImpl(UnitWork unitWork, ConfigOfBillRepository configOfBillRepository, DailyBillRepository dailyBillRepository, MonthlyBillRepository monthlyBillRepository, RdCompanyRepository rdCompanyRepository, BillStatusCheckpointRepository billStatusCheckpointRepository, EventDispatcher eventDispatcher) {
        this.unitWork = unitWork;
        this.configOfBillRepository = configOfBillRepository;
        this.dailyBillRepository = dailyBillRepository;
        this.monthlyBillRepository = monthlyBillRepository;
        this.rdCompanyRepository = rdCompanyRepository;
        this.billStatusCheckpointRepository = billStatusCheckpointRepository;
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public void dispatch(GenerateMonthlyBillCommand command) {
        java.util.Date date = command.getDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        ConfigOfBillEntity configOfBill = this.configOfBillRepository.get();
        int dayOfMonth = calendar.get(5);
        calendar.add(2, -1);
        calendar.set(5, 1);
        Collection<BillType> billTypes = command.getBillTypes();
        if (CollectionUtils.isEmpty(billTypes)) {
            return;
        }
        List<String> orgIds = this.rdCompanyRepository.selectAllCompanyIds();
        Map<String, List<BillStatusCheckpointEntity>> dailyBillStatusMap = this.billStatusCheckpointRepository.selectAll(0).stream().collect(Collectors.groupingBy(BillStatusCheckpointEntity::getOrganizationId));
        Map<String, List<BillStatusCheckpointEntity>> monthlyBillStatusMap = this.billStatusCheckpointRepository.selectAll(1).stream().collect(Collectors.groupingBy(BillStatusCheckpointEntity::getOrganizationId));
        List currentMonthlyBillEntityList = this.getCurrentMonthlyBillEntities(billTypes, dayOfMonth, configOfBill, calendar).stream().filter(ix -> {
            String orgId = ix.getOrgId();
            List entityList = (List)dailyBillStatusMap.get(orgId);
            if (CollectionUtils.isEmpty((Collection)entityList)) {
                return false;
            }
            return BillUtils.compareDate(((BillStatusCheckpointEntity)((Object)((Object)entityList.get(0)))).getLastUpdate(), BillUtils.getLastDateOfPreviousMonth(date)) >= 0;
        }).collect(Collectors.toList());
        Map<String, List<MonthlyBillEntity>> currentBillsMap = currentMonthlyBillEntityList.stream().collect(Collectors.groupingBy(MonthlyBillEntity::getOrgId));
        boolean hasBillGenerated = false;
        String transactionID = this.unitWork.beginTransaction();
        ArrayList<MonthlyBillEntity> monthlyBillEntityBatch = new ArrayList<MonthlyBillEntity>();
        ArrayList<BillStatusCheckpointEntity> insertBillStatusList = new ArrayList<BillStatusCheckpointEntity>();
        ArrayList<BillStatusCheckpointEntity> updateBillStatusList = new ArrayList<BillStatusCheckpointEntity>();
        int index = 0;
        for (int i = 0; i < orgIds.size(); ++i) {
            ++index;
            String orgId = orgIds.get(i);
            try {
                if (!CollectionUtils.isEmpty((Collection)currentBillsMap.get(orgId))) {
                    monthlyBillEntityBatch.addAll((Collection)currentBillsMap.get(orgId));
                }
                List<BillStatusCheckpointEntity> monthlyBillStatusEntities = monthlyBillStatusMap.get(orgId);
                List<BillStatusCheckpointEntity> dailyBillStatusEntites = dailyBillStatusMap.get(orgId);
                Date dailyLastUpdate = CollectionUtils.isEmpty(dailyBillStatusEntites) ? null : dailyBillStatusEntites.get(0).getLastUpdate();
                for (BillType billType : billTypes) {
                    java.util.Date startDate = null;
                    java.util.Date endDate = null;
                    java.util.Date billLastUpdate = null;
                    int billDateCmp = 0;
                    switch (billType) {
                        case Attendance: {
                            billDateCmp = dayOfMonth - (configOfBill.getSignGenBillMonth() == null ? 0 : configOfBill.getSignGenBillMonth());
                            break;
                        }
                        case RollCall: {
                            billDateCmp = dayOfMonth - (configOfBill.getCallGenBillMonth() == null ? 0 : configOfBill.getCallGenBillMonth());
                            break;
                        }
                        case Track: {
                            billDateCmp = dayOfMonth - (configOfBill.getTrackGenBillMonth() == null ? 0 : configOfBill.getTrackGenBillMonth());
                            break;
                        }
                        case Fence: {
                            billDateCmp = dayOfMonth - (configOfBill.getFenGenBillMonth() == null ? 0 : configOfBill.getFenGenBillMonth());
                        }
                    }
                    if (billDateCmp < 0) {
                        billLastUpdate = endDate = BillUtils.getLastDateOfCurOrPreMonth(BillUtils.getMin(BillUtils.getLastDateOfPreviousMonth(calendar.getTime()), dailyLastUpdate));
                    } else if (billDateCmp == 0) {
                        endDate = BillUtils.getLastDateOfCurOrPreMonth(BillUtils.getMin(BillUtils.getLastDateOfPreviousMonth(calendar.getTime()), dailyLastUpdate));
                        billLastUpdate = BillUtils.compareDate(dailyLastUpdate, BillUtils.getLastDateOfPreviousMonth(date)) >= 0 ? calendar.getTime() : endDate;
                    } else {
                        billLastUpdate = endDate = BillUtils.getLastDateOfCurOrPreMonth(BillUtils.getMin(BillUtils.getLastDateOfPreviousMonth(date), dailyLastUpdate));
                    }
                    if (endDate == null) continue;
                    if (CollectionUtils.isEmpty(monthlyBillStatusEntities) || !monthlyBillStatusEntities.stream().anyMatch(ix -> ix.getBillType() == billType)) {
                        startDate = null;
                        insertBillStatusList.add(BillStatusCheckpointEntity.create(null, orgId, 1, billType, Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(billLastUpdate))));
                    } else {
                        BillStatusCheckpointEntity entity = (BillStatusCheckpointEntity)((Object)monthlyBillStatusEntities.stream().filter(ix -> ix.getBillType() == billType).collect(Collectors.toList()).get(0));
                        startDate = BillUtils.getFirstDateOfNextMonth(entity.getLastUpdate());
                        if (BillUtils.compareMonth(entity.getLastUpdate(), billLastUpdate) != 0) {
                            entity.setLastUpdate(Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(billLastUpdate)));
                            updateBillStatusList.add(entity);
                        }
                    }
                    if (BillUtils.compareMonth(startDate, endDate) > 0) continue;
                    List<MonthBillPojo> missedMonthBills = this.dailyBillRepository.calcMonthBillRange(orgId, billType, startDate, endDate);
                    List missedMonthBillEntites = missedMonthBills.stream().map(ix -> BillUtils.createMonthlyBillEntity(configOfBill, ix, billType, ix.getBillMonth())).collect(Collectors.toList());
                    monthlyBillEntityBatch.addAll(missedMonthBillEntites);
                }
                if (index % 100 != 0 && i != orgIds.size() - 1) continue;
                if (!monthlyBillEntityBatch.isEmpty()) {
                    this.monthlyBillRepository.generateBills(monthlyBillEntityBatch);
                }
                if (!CollectionUtils.isEmpty(insertBillStatusList)) {
                    this.billStatusCheckpointRepository.insertBatch(insertBillStatusList);
                }
                if (!CollectionUtils.isEmpty(updateBillStatusList)) {
                    this.billStatusCheckpointRepository.updateBatch(updateBillStatusList);
                }
                this.unitWork.commit(transactionID);
                hasBillGenerated = hasBillGenerated || !monthlyBillEntityBatch.isEmpty();
                index = 0;
                if (i < orgIds.size() - 1) {
                    transactionID = this.unitWork.beginTransaction();
                }
                monthlyBillEntityBatch.clear();
                insertBillStatusList.clear();
                updateBillStatusList.clear();
                continue;
            }
            catch (Exception e) {
                logger.error("\u751f\u6210\u6708\u8d26\u5355\u53d1\u751f\u5f02\u5e38\u3002organizationId={},date={},exception={}", new Object[]{monthlyBillEntityBatch.stream().map(ix -> ix.getOrgId()).collect(Collectors.toList()), date, e});
                this.unitWork.rollback(transactionID);
                index = 0;
                if (i < orgIds.size() - 1) {
                    transactionID = this.unitWork.beginTransaction();
                }
                monthlyBillEntityBatch.clear();
                insertBillStatusList.clear();
                updateBillStatusList.clear();
            }
        }
        if (hasBillGenerated) {
            this.eventDispatcher.dispatch((DomainEvent)MonthlyBillGenerateEvent.create(new SimpleDateFormat("yyyyMM").format(calendar.getTime())));
        }
    }

    private List<MonthlyBillEntity> getCurrentMonthlyBillEntities(Collection<BillType> billTypes, int dayOfMonth, ConfigOfBillEntity configOfBill, Calendar calendar) {
        ArrayList<MonthlyBillEntity> currentMonthlyBillEntityList = new ArrayList<MonthlyBillEntity>();
        for (BillType billType : billTypes) {
            switch (billType) {
                case Attendance: {
                    if (dayOfMonth != (configOfBill.getSignGenBillMonth() == null ? 0 : configOfBill.getSignGenBillMonth())) break;
                    currentMonthlyBillEntityList.addAll(this.getMonthlyBills(calendar, configOfBill, billType));
                    break;
                }
                case RollCall: {
                    if (dayOfMonth != (configOfBill.getCallGenBillMonth() == null ? 0 : configOfBill.getCallGenBillMonth())) break;
                    currentMonthlyBillEntityList.addAll(this.getMonthlyBills(calendar, configOfBill, billType));
                    break;
                }
                case Track: {
                    if (dayOfMonth != (configOfBill.getTrackGenBillMonth() == null ? 0 : configOfBill.getTrackGenBillMonth())) break;
                    currentMonthlyBillEntityList.addAll(this.getMonthlyBills(calendar, configOfBill, billType));
                    break;
                }
                case Fence: {
                    if (dayOfMonth != (configOfBill.getFenGenBillMonth() == null ? 0 : configOfBill.getFenGenBillMonth())) break;
                    currentMonthlyBillEntityList.addAll(this.getMonthlyBills(calendar, configOfBill, billType));
                }
            }
        }
        return currentMonthlyBillEntityList;
    }

    private List<MonthlyBillEntity> getMonthlyBills(Calendar calendar, ConfigOfBillEntity configOfBill, BillType type) {
        String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
        List<MonthBillPojo> attendanceMonthBills = this.dailyBillRepository.calcMonthBill(dateStr, type);
        List<MonthlyBillEntity> monthlyBillEntityList = attendanceMonthBills.stream().map(ix -> BillUtils.createMonthlyBillEntity(configOfBill, ix, type, calendar.getTime())).collect(Collectors.toList());
        return monthlyBillEntityList;
    }
}

