/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.domains.entities.RoomUserEntity;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.enums.DispatchReasonType;
import com.bcxin.tenant.open.infrastructures.enums.ProcessedStatus;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

@TableName(value="vga_rooms")
public class RoomEntity
extends EntityAbstract
implements Aggregate {
    @TableId(value="id")
    private Long id;
    @TableField(value="created_time")
    private Timestamp createdTime;
    @TableField(value="begin_Time")
    private Timestamp beginTime;
    @TableField(value="end_Time")
    private Timestamp endTime;
    @TableField(value="is_activated")
    private Boolean activated;
    @TableField(value="leave_time")
    private Timestamp leaveTime;
    @TableField(value="organization_id")
    private String organizationId;
    @TableField(value="employee_id")
    private String employeeId;
    @TableField(value="is_tencent_closed")
    private Boolean tencentClosed;
    @TableField(value="tencent_closed_time")
    private Timestamp tencentClosedTime;
    @TableField(value="processed_status", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private ProcessedStatus status;
    @TableField(value="last_processed_time")
    private Timestamp lastProcessedTime;
    @TableField(value="last_processed_result")
    private String lastProcessedResult;
    @TableField(value="communicated_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private CommunicatedType communicatedType;
    @TableField(value="yardman_type")
    private int yardmanType;
    @TableField(value="reference_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private DispatchReasonType referenceType;
    @TableField(value="reference_number")
    private String referenceNumber;
    private Collection<RoomUserEntity> roomUsers;
    @TableField(value="desk_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private DeskType deskType;

    public RoomEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setBeginTime(this.getCreatedTime());
        this.setActivated(true);
        this.setTencentClosed(false);
        this.setStatus(ProcessedStatus.Init);
    }

    public static RoomEntity create(Long id, CommunicatedType communicatedType, int yardmanType, String employeeId, String organizationId, DispatchReasonType referenceType, String referenceNumber, DeskType deskType) {
        RoomEntity room = new RoomEntity();
        room.setId(id);
        room.setEmployeeId(employeeId);
        room.setOrganizationId(organizationId);
        room.setCommunicatedType(communicatedType);
        room.setYardmanType(yardmanType);
        room.setReferenceType(referenceType);
        room.setReferenceNumber(referenceNumber);
        room.setDeskType(deskType);
        return room;
    }

    public void leave() {
        this.setActivated(false);
        this.setLeaveTime(Timestamp.from(Instant.now()));
    }

    public void addUser(Long id, String employeeId, String tenantUserId, String employeeName, String organizationId, String organizationName, String tencentUserId, String securityStationId, String securityStationName, String superviseDepartId, String cid, boolean isSponsor, boolean isSuperviseDepartRole) {
        Collection<RoomUserEntity> roomUsers = this.getRoomUsers();
        if (roomUsers == null) {
            roomUsers = new ArrayList<RoomUserEntity>();
        }
        roomUsers.add(RoomUserEntity.create(this.getId(), id, employeeId, tenantUserId, cid, employeeName, organizationId, organizationName, tencentUserId, securityStationId, securityStationName, superviseDepartId, isSponsor, isSuperviseDepartRole));
        this.setRoomUsers(roomUsers);
    }

    public Long getId() {
        return this.id;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Timestamp getBeginTime() {
        return this.beginTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public Boolean getActivated() {
        return this.activated;
    }

    public Timestamp getLeaveTime() {
        return this.leaveTime;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public Boolean getTencentClosed() {
        return this.tencentClosed;
    }

    public Timestamp getTencentClosedTime() {
        return this.tencentClosedTime;
    }

    public ProcessedStatus getStatus() {
        return this.status;
    }

    public Timestamp getLastProcessedTime() {
        return this.lastProcessedTime;
    }

    public String getLastProcessedResult() {
        return this.lastProcessedResult;
    }

    public CommunicatedType getCommunicatedType() {
        return this.communicatedType;
    }

    public int getYardmanType() {
        return this.yardmanType;
    }

    public DispatchReasonType getReferenceType() {
        return this.referenceType;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public Collection<RoomUserEntity> getRoomUsers() {
        return this.roomUsers;
    }

    public DeskType getDeskType() {
        return this.deskType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public void setBeginTime(Timestamp beginTime) {
        this.beginTime = beginTime;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public void setActivated(Boolean activated) {
        this.activated = activated;
    }

    public void setLeaveTime(Timestamp leaveTime) {
        this.leaveTime = leaveTime;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public void setTencentClosed(Boolean tencentClosed) {
        this.tencentClosed = tencentClosed;
    }

    public void setTencentClosedTime(Timestamp tencentClosedTime) {
        this.tencentClosedTime = tencentClosedTime;
    }

    public void setStatus(ProcessedStatus status) {
        this.status = status;
    }

    public void setLastProcessedTime(Timestamp lastProcessedTime) {
        this.lastProcessedTime = lastProcessedTime;
    }

    public void setLastProcessedResult(String lastProcessedResult) {
        this.lastProcessedResult = lastProcessedResult;
    }

    public void setCommunicatedType(CommunicatedType communicatedType) {
        this.communicatedType = communicatedType;
    }

    public void setYardmanType(int yardmanType) {
        this.yardmanType = yardmanType;
    }

    public void setReferenceType(DispatchReasonType referenceType) {
        this.referenceType = referenceType;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public void setRoomUsers(Collection<RoomUserEntity> roomUsers) {
        this.roomUsers = roomUsers;
    }

    public void setDeskType(DeskType deskType) {
        this.deskType = deskType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoomEntity)) {
            return false;
        }
        RoomEntity other = (RoomEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getYardmanType() != other.getYardmanType()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$activated = this.getActivated();
        Boolean other$activated = other.getActivated();
        if (this$activated == null ? other$activated != null : !((Object)this$activated).equals(other$activated)) {
            return false;
        }
        Boolean this$tencentClosed = this.getTencentClosed();
        Boolean other$tencentClosed = other.getTencentClosed();
        if (this$tencentClosed == null ? other$tencentClosed != null : !((Object)this$tencentClosed).equals(other$tencentClosed)) {
            return false;
        }
        Timestamp this$createdTime = this.getCreatedTime();
        Timestamp other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        Timestamp this$beginTime = this.getBeginTime();
        Timestamp other$beginTime = other.getBeginTime();
        if (this$beginTime == null ? other$beginTime != null : !((Object)this$beginTime).equals(other$beginTime)) {
            return false;
        }
        Timestamp this$endTime = this.getEndTime();
        Timestamp other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        Timestamp this$leaveTime = this.getLeaveTime();
        Timestamp other$leaveTime = other.getLeaveTime();
        if (this$leaveTime == null ? other$leaveTime != null : !((Object)this$leaveTime).equals(other$leaveTime)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$employeeId = this.getEmployeeId();
        String other$employeeId = other.getEmployeeId();
        if (this$employeeId == null ? other$employeeId != null : !this$employeeId.equals(other$employeeId)) {
            return false;
        }
        Timestamp this$tencentClosedTime = this.getTencentClosedTime();
        Timestamp other$tencentClosedTime = other.getTencentClosedTime();
        if (this$tencentClosedTime == null ? other$tencentClosedTime != null : !((Object)this$tencentClosedTime).equals(other$tencentClosedTime)) {
            return false;
        }
        ProcessedStatus this$status = this.getStatus();
        ProcessedStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Timestamp this$lastProcessedTime = this.getLastProcessedTime();
        Timestamp other$lastProcessedTime = other.getLastProcessedTime();
        if (this$lastProcessedTime == null ? other$lastProcessedTime != null : !((Object)this$lastProcessedTime).equals(other$lastProcessedTime)) {
            return false;
        }
        String this$lastProcessedResult = this.getLastProcessedResult();
        String other$lastProcessedResult = other.getLastProcessedResult();
        if (this$lastProcessedResult == null ? other$lastProcessedResult != null : !this$lastProcessedResult.equals(other$lastProcessedResult)) {
            return false;
        }
        CommunicatedType this$communicatedType = this.getCommunicatedType();
        CommunicatedType other$communicatedType = other.getCommunicatedType();
        if (this$communicatedType == null ? other$communicatedType != null : !this$communicatedType.equals(other$communicatedType)) {
            return false;
        }
        DispatchReasonType this$referenceType = this.getReferenceType();
        DispatchReasonType other$referenceType = other.getReferenceType();
        if (this$referenceType == null ? other$referenceType != null : !this$referenceType.equals(other$referenceType)) {
            return false;
        }
        String this$referenceNumber = this.getReferenceNumber();
        String other$referenceNumber = other.getReferenceNumber();
        if (this$referenceNumber == null ? other$referenceNumber != null : !this$referenceNumber.equals(other$referenceNumber)) {
            return false;
        }
        Collection<RoomUserEntity> this$roomUsers = this.getRoomUsers();
        Collection<RoomUserEntity> other$roomUsers = other.getRoomUsers();
        if (this$roomUsers == null ? other$roomUsers != null : !((Object)this$roomUsers).equals(other$roomUsers)) {
            return false;
        }
        DeskType this$deskType = this.getDeskType();
        DeskType other$deskType = other.getDeskType();
        return !(this$deskType == null ? other$deskType != null : !this$deskType.equals(other$deskType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoomEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getYardmanType();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $activated = this.getActivated();
        result = result * 59 + ($activated == null ? 43 : ((Object)$activated).hashCode());
        Boolean $tencentClosed = this.getTencentClosed();
        result = result * 59 + ($tencentClosed == null ? 43 : ((Object)$tencentClosed).hashCode());
        Timestamp $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        Timestamp $beginTime = this.getBeginTime();
        result = result * 59 + ($beginTime == null ? 43 : ((Object)$beginTime).hashCode());
        Timestamp $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        Timestamp $leaveTime = this.getLeaveTime();
        result = result * 59 + ($leaveTime == null ? 43 : ((Object)$leaveTime).hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $employeeId = this.getEmployeeId();
        result = result * 59 + ($employeeId == null ? 43 : $employeeId.hashCode());
        Timestamp $tencentClosedTime = this.getTencentClosedTime();
        result = result * 59 + ($tencentClosedTime == null ? 43 : ((Object)$tencentClosedTime).hashCode());
        ProcessedStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Timestamp $lastProcessedTime = this.getLastProcessedTime();
        result = result * 59 + ($lastProcessedTime == null ? 43 : ((Object)$lastProcessedTime).hashCode());
        String $lastProcessedResult = this.getLastProcessedResult();
        result = result * 59 + ($lastProcessedResult == null ? 43 : $lastProcessedResult.hashCode());
        CommunicatedType $communicatedType = this.getCommunicatedType();
        result = result * 59 + ($communicatedType == null ? 43 : $communicatedType.hashCode());
        DispatchReasonType $referenceType = this.getReferenceType();
        result = result * 59 + ($referenceType == null ? 43 : $referenceType.hashCode());
        String $referenceNumber = this.getReferenceNumber();
        result = result * 59 + ($referenceNumber == null ? 43 : $referenceNumber.hashCode());
        Collection<RoomUserEntity> $roomUsers = this.getRoomUsers();
        result = result * 59 + ($roomUsers == null ? 43 : ((Object)$roomUsers).hashCode());
        DeskType $deskType = this.getDeskType();
        result = result * 59 + ($deskType == null ? 43 : $deskType.hashCode());
        return result;
    }

    public String toString() {
        return "RoomEntity(id=" + this.getId() + ", createdTime=" + this.getCreatedTime() + ", beginTime=" + this.getBeginTime() + ", endTime=" + this.getEndTime() + ", activated=" + this.getActivated() + ", leaveTime=" + this.getLeaveTime() + ", organizationId=" + this.getOrganizationId() + ", employeeId=" + this.getEmployeeId() + ", tencentClosed=" + this.getTencentClosed() + ", tencentClosedTime=" + this.getTencentClosedTime() + ", status=" + this.getStatus() + ", lastProcessedTime=" + this.getLastProcessedTime() + ", lastProcessedResult=" + this.getLastProcessedResult() + ", communicatedType=" + this.getCommunicatedType() + ", yardmanType=" + this.getYardmanType() + ", referenceType=" + this.getReferenceType() + ", referenceNumber=" + this.getReferenceNumber() + ", roomUsers=" + this.getRoomUsers() + ", deskType=" + this.getDeskType() + ")";
    }
}

