/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.domains.dtos.PoliceIncidentSuperviseDepartDTO;
import com.bcxin.tenant.open.domains.entities.valueTypes.GeoPointValueType;
import com.bcxin.tenant.open.domains.typeHandlers.GeoPointTypeHandler;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventCategory;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventLevel;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventStatus;
import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Set;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.springframework.util.StringUtils;

@TableName(value="police_incidents", autoResultMap=true)
public class PoliceIncidentsEntity
extends EntityAbstract
implements Aggregate {
    @TableId(value="id")
    private Long id;
    @TableField(value="tenant_user_id")
    private String tenantUserId;
    @TableField(value="tenant_employee_id")
    private String tenantEmployeeId;
    @TableField(value="organization_id")
    private String organizationId;
    @TableField(value="organization_name")
    private String organizationName;
    @TableField(value="security_station_id")
    private String securityStationId;
    @TableField(value="security_station_name")
    private String securityStationName;
    @TableField(value="security_station_address")
    private String securityStationAddress;
    @TableField(value="supervise_depart_id")
    private String superviseDepartId;
    @TableField(value="supervise_depart_name")
    private String superviseDepartName;
    @TableField(value="code")
    private String code;
    @TableField(value="police_name")
    private String name;
    @TableField(value="description")
    private String description;
    @TableField(value="contact")
    private String contact;
    @TableField(value="police_status", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private PoliceEventStatus policeEventStatus;
    @TableField(value="category", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private PoliceEventCategory category;
    @TableField(value="police_level", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private PoliceEventLevel policeEventLevel;
    @TableField(value="type", jdbcType=JdbcType.TINYINT)
    private int policeEventType;
    @TableField(value="address")
    private String address;
    @TableField(value="reason")
    private String reason;
    @TableField(value="lon_lat", typeHandler=GeoPointTypeHandler.class)
    private GeoPointValueType lonLat;
    @TableField(value="location")
    private String location;
    @TableField(value="action_taken")
    private String actionTaken;
    @TableField(value="action_tendency")
    private String actionTendency;
    @TableField(value="processed_suggestion")
    private String processedSuggestion;
    @TableField(value="processed_locale_guidance")
    private String processedLocaleGuidance;
    @TableField(value="processed_user_id")
    private String processedUserId;
    @TableField(value="processed_user_name")
    private String processedUserName;
    @TableField(value="scene_url")
    private String sceneUrl;
    @TableField(value="processed_time")
    private Timestamp processedTime;
    @TableField(value="created_time")
    private Timestamp createdTime;
    @TableField(value="emp_name")
    private String empName;
    @TableField(value="emp_id_number")
    private String empIdNumber;
    @TableField(value="project_id")
    private String projectId;
    @TableField(value="project_name")
    private String projectName;
    @TableField(value="calculated_resource_type")
    private int calculatedResourceType;

    public PoliceIncidentsEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setPoliceEventStatus(PoliceEventStatus.None);
    }

    public void makeAsOverStatus(String processUserId, String processUserName, PoliceEventStatus status) {
        this.setProcessedUserId(processUserId);
        this.setProcessedUserName(processUserName);
        this.setPoliceEventStatus(status);
        this.setProcessedTime(Timestamp.from(Instant.now()));
    }

    public void process(String processUserId, String processUserName, PoliceEventStatus status, String actionTaken, String actionTendency, String suggestion, String localeGuidance) {
        if (status == PoliceEventStatus.None) {
            throw new BadTenantException("\u7981\u6b62\u5c06\u8b66\u60c5\u4e0a\u62a5\u72b6\u6001\u66f4\u6539\u56de\u5f85\u5904\u7406");
        }
        this.setPoliceEventStatus(status);
        this.setActionTaken(actionTaken);
        this.setActionTendency(actionTendency);
        this.setProcessedSuggestion(suggestion);
        this.setProcessedLocaleGuidance(localeGuidance);
        this.setProcessedUserId(processUserId);
        this.setProcessedUserName(processUserName);
        this.setProcessedTime(Timestamp.from(Instant.now()));
    }

    public static PoliceIncidentsEntity createSos(JsonProvider jsonProvider, String code, String tenantUserId, String tenantEmployeeId, String organizationId, String organizationName, String securityStationId, String securityStationName, String projectId, String projectName, String securityStationAddress, String superviseDepartId, String superviseDepartName, String empIdNumber, String empName, double latitude, double longitude, String address, Set<ResourceType> resourceTypes) {
        PoliceIncidentsEntity entity = new PoliceIncidentsEntity();
        entity.setCode(code);
        entity.setCategory(PoliceEventCategory.Sos);
        entity.setSecurityStationAddress(securityStationAddress);
        entity.setOrganizationName(organizationName);
        entity.setSecurityStationName(securityStationName);
        entity.setEmpIdNumber(empIdNumber);
        entity.setEmpName(empName);
        entity.setTenantUserId(tenantUserId);
        entity.setTenantEmployeeId(tenantEmployeeId);
        entity.setOrganizationId(organizationId);
        entity.setProjectId(projectId);
        entity.setProjectName(projectName);
        entity.setSecurityStationId(securityStationId);
        entity.setSuperviseDepartId(superviseDepartId);
        entity.setSuperviseDepartName(superviseDepartName);
        entity.setLonLat(GeoPointValueType.create(latitude, longitude));
        if (StringUtils.hasLength((String)address)) {
            entity.setAddress(address);
        } else {
            entity.setAddress("-");
        }
        entity.setPoliceEventType(6);
        entity.setPoliceEventLevel(PoliceEventLevel.Greats);
        entity.setName("\u4e00\u952e\u62a5\u8b66");
        entity.setReason(jsonProvider.getJson((Object)PoliceIncidentSuperviseDepartDTO.create(superviseDepartId, superviseDepartName)));
        if ("#1".equalsIgnoreCase(entity.getSuperviseDepartName())) {
            entity.setSuperviseDepartName(" ");
        }
        if ("#1".equalsIgnoreCase(entity.getSecurityStationName())) {
            entity.setSecurityStationName(" ");
        }
        Timestamp now = Timestamp.from(Instant.now());
        entity.setCreatedTime(now);
        entity.setLocation(address);
        entity.setCalculatedResourceType(ResourceType.getCalculatedResourceValue(resourceTypes));
        return entity;
    }

    public Long getId() {
        return this.id;
    }

    public String getTenantUserId() {
        return this.tenantUserId;
    }

    public String getTenantEmployeeId() {
        return this.tenantEmployeeId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public String getSecurityStationId() {
        return this.securityStationId;
    }

    public String getSecurityStationName() {
        return this.securityStationName;
    }

    public String getSecurityStationAddress() {
        return this.securityStationAddress;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public String getSuperviseDepartName() {
        return this.superviseDepartName;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContact() {
        return this.contact;
    }

    public PoliceEventStatus getPoliceEventStatus() {
        return this.policeEventStatus;
    }

    public PoliceEventCategory getCategory() {
        return this.category;
    }

    public PoliceEventLevel getPoliceEventLevel() {
        return this.policeEventLevel;
    }

    public int getPoliceEventType() {
        return this.policeEventType;
    }

    public String getAddress() {
        return this.address;
    }

    public String getReason() {
        return this.reason;
    }

    public GeoPointValueType getLonLat() {
        return this.lonLat;
    }

    public String getLocation() {
        return this.location;
    }

    public String getActionTaken() {
        return this.actionTaken;
    }

    public String getActionTendency() {
        return this.actionTendency;
    }

    public String getProcessedSuggestion() {
        return this.processedSuggestion;
    }

    public String getProcessedLocaleGuidance() {
        return this.processedLocaleGuidance;
    }

    public String getProcessedUserId() {
        return this.processedUserId;
    }

    public String getProcessedUserName() {
        return this.processedUserName;
    }

    public String getSceneUrl() {
        return this.sceneUrl;
    }

    public Timestamp getProcessedTime() {
        return this.processedTime;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public String getEmpName() {
        return this.empName;
    }

    public String getEmpIdNumber() {
        return this.empIdNumber;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public int getCalculatedResourceType() {
        return this.calculatedResourceType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTenantUserId(String tenantUserId) {
        this.tenantUserId = tenantUserId;
    }

    public void setTenantEmployeeId(String tenantEmployeeId) {
        this.tenantEmployeeId = tenantEmployeeId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public void setSecurityStationId(String securityStationId) {
        this.securityStationId = securityStationId;
    }

    public void setSecurityStationName(String securityStationName) {
        this.securityStationName = securityStationName;
    }

    public void setSecurityStationAddress(String securityStationAddress) {
        this.securityStationAddress = securityStationAddress;
    }

    public void setSuperviseDepartId(String superviseDepartId) {
        this.superviseDepartId = superviseDepartId;
    }

    public void setSuperviseDepartName(String superviseDepartName) {
        this.superviseDepartName = superviseDepartName;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public void setPoliceEventStatus(PoliceEventStatus policeEventStatus) {
        this.policeEventStatus = policeEventStatus;
    }

    public void setCategory(PoliceEventCategory category) {
        this.category = category;
    }

    public void setPoliceEventLevel(PoliceEventLevel policeEventLevel) {
        this.policeEventLevel = policeEventLevel;
    }

    public void setPoliceEventType(int policeEventType) {
        this.policeEventType = policeEventType;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setLonLat(GeoPointValueType lonLat) {
        this.lonLat = lonLat;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setActionTaken(String actionTaken) {
        this.actionTaken = actionTaken;
    }

    public void setActionTendency(String actionTendency) {
        this.actionTendency = actionTendency;
    }

    public void setProcessedSuggestion(String processedSuggestion) {
        this.processedSuggestion = processedSuggestion;
    }

    public void setProcessedLocaleGuidance(String processedLocaleGuidance) {
        this.processedLocaleGuidance = processedLocaleGuidance;
    }

    public void setProcessedUserId(String processedUserId) {
        this.processedUserId = processedUserId;
    }

    public void setProcessedUserName(String processedUserName) {
        this.processedUserName = processedUserName;
    }

    public void setSceneUrl(String sceneUrl) {
        this.sceneUrl = sceneUrl;
    }

    public void setProcessedTime(Timestamp processedTime) {
        this.processedTime = processedTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public void setEmpName(String empName) {
        this.empName = empName;
    }

    public void setEmpIdNumber(String empIdNumber) {
        this.empIdNumber = empIdNumber;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setCalculatedResourceType(int calculatedResourceType) {
        this.calculatedResourceType = calculatedResourceType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PoliceIncidentsEntity)) {
            return false;
        }
        PoliceIncidentsEntity other = (PoliceIncidentsEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPoliceEventType() != other.getPoliceEventType()) {
            return false;
        }
        if (this.getCalculatedResourceType() != other.getCalculatedResourceType()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$tenantUserId = this.getTenantUserId();
        String other$tenantUserId = other.getTenantUserId();
        if (this$tenantUserId == null ? other$tenantUserId != null : !this$tenantUserId.equals(other$tenantUserId)) {
            return false;
        }
        String this$tenantEmployeeId = this.getTenantEmployeeId();
        String other$tenantEmployeeId = other.getTenantEmployeeId();
        if (this$tenantEmployeeId == null ? other$tenantEmployeeId != null : !this$tenantEmployeeId.equals(other$tenantEmployeeId)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$organizationName = this.getOrganizationName();
        String other$organizationName = other.getOrganizationName();
        if (this$organizationName == null ? other$organizationName != null : !this$organizationName.equals(other$organizationName)) {
            return false;
        }
        String this$securityStationId = this.getSecurityStationId();
        String other$securityStationId = other.getSecurityStationId();
        if (this$securityStationId == null ? other$securityStationId != null : !this$securityStationId.equals(other$securityStationId)) {
            return false;
        }
        String this$securityStationName = this.getSecurityStationName();
        String other$securityStationName = other.getSecurityStationName();
        if (this$securityStationName == null ? other$securityStationName != null : !this$securityStationName.equals(other$securityStationName)) {
            return false;
        }
        String this$securityStationAddress = this.getSecurityStationAddress();
        String other$securityStationAddress = other.getSecurityStationAddress();
        if (this$securityStationAddress == null ? other$securityStationAddress != null : !this$securityStationAddress.equals(other$securityStationAddress)) {
            return false;
        }
        String this$superviseDepartId = this.getSuperviseDepartId();
        String other$superviseDepartId = other.getSuperviseDepartId();
        if (this$superviseDepartId == null ? other$superviseDepartId != null : !this$superviseDepartId.equals(other$superviseDepartId)) {
            return false;
        }
        String this$superviseDepartName = this.getSuperviseDepartName();
        String other$superviseDepartName = other.getSuperviseDepartName();
        if (this$superviseDepartName == null ? other$superviseDepartName != null : !this$superviseDepartName.equals(other$superviseDepartName)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$contact = this.getContact();
        String other$contact = other.getContact();
        if (this$contact == null ? other$contact != null : !this$contact.equals(other$contact)) {
            return false;
        }
        PoliceEventStatus this$policeEventStatus = this.getPoliceEventStatus();
        PoliceEventStatus other$policeEventStatus = other.getPoliceEventStatus();
        if (this$policeEventStatus == null ? other$policeEventStatus != null : !this$policeEventStatus.equals(other$policeEventStatus)) {
            return false;
        }
        PoliceEventCategory this$category = this.getCategory();
        PoliceEventCategory other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        PoliceEventLevel this$policeEventLevel = this.getPoliceEventLevel();
        PoliceEventLevel other$policeEventLevel = other.getPoliceEventLevel();
        if (this$policeEventLevel == null ? other$policeEventLevel != null : !this$policeEventLevel.equals(other$policeEventLevel)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        GeoPointValueType this$lonLat = this.getLonLat();
        GeoPointValueType other$lonLat = other.getLonLat();
        if (this$lonLat == null ? other$lonLat != null : !this$lonLat.equals(other$lonLat)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$actionTaken = this.getActionTaken();
        String other$actionTaken = other.getActionTaken();
        if (this$actionTaken == null ? other$actionTaken != null : !this$actionTaken.equals(other$actionTaken)) {
            return false;
        }
        String this$actionTendency = this.getActionTendency();
        String other$actionTendency = other.getActionTendency();
        if (this$actionTendency == null ? other$actionTendency != null : !this$actionTendency.equals(other$actionTendency)) {
            return false;
        }
        String this$processedSuggestion = this.getProcessedSuggestion();
        String other$processedSuggestion = other.getProcessedSuggestion();
        if (this$processedSuggestion == null ? other$processedSuggestion != null : !this$processedSuggestion.equals(other$processedSuggestion)) {
            return false;
        }
        String this$processedLocaleGuidance = this.getProcessedLocaleGuidance();
        String other$processedLocaleGuidance = other.getProcessedLocaleGuidance();
        if (this$processedLocaleGuidance == null ? other$processedLocaleGuidance != null : !this$processedLocaleGuidance.equals(other$processedLocaleGuidance)) {
            return false;
        }
        String this$processedUserId = this.getProcessedUserId();
        String other$processedUserId = other.getProcessedUserId();
        if (this$processedUserId == null ? other$processedUserId != null : !this$processedUserId.equals(other$processedUserId)) {
            return false;
        }
        String this$processedUserName = this.getProcessedUserName();
        String other$processedUserName = other.getProcessedUserName();
        if (this$processedUserName == null ? other$processedUserName != null : !this$processedUserName.equals(other$processedUserName)) {
            return false;
        }
        String this$sceneUrl = this.getSceneUrl();
        String other$sceneUrl = other.getSceneUrl();
        if (this$sceneUrl == null ? other$sceneUrl != null : !this$sceneUrl.equals(other$sceneUrl)) {
            return false;
        }
        Timestamp this$processedTime = this.getProcessedTime();
        Timestamp other$processedTime = other.getProcessedTime();
        if (this$processedTime == null ? other$processedTime != null : !((Object)this$processedTime).equals(other$processedTime)) {
            return false;
        }
        Timestamp this$createdTime = this.getCreatedTime();
        Timestamp other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        String this$empName = this.getEmpName();
        String other$empName = other.getEmpName();
        if (this$empName == null ? other$empName != null : !this$empName.equals(other$empName)) {
            return false;
        }
        String this$empIdNumber = this.getEmpIdNumber();
        String other$empIdNumber = other.getEmpIdNumber();
        if (this$empIdNumber == null ? other$empIdNumber != null : !this$empIdNumber.equals(other$empIdNumber)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        return !(this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PoliceIncidentsEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPoliceEventType();
        result = result * 59 + this.getCalculatedResourceType();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $tenantUserId = this.getTenantUserId();
        result = result * 59 + ($tenantUserId == null ? 43 : $tenantUserId.hashCode());
        String $tenantEmployeeId = this.getTenantEmployeeId();
        result = result * 59 + ($tenantEmployeeId == null ? 43 : $tenantEmployeeId.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $organizationName = this.getOrganizationName();
        result = result * 59 + ($organizationName == null ? 43 : $organizationName.hashCode());
        String $securityStationId = this.getSecurityStationId();
        result = result * 59 + ($securityStationId == null ? 43 : $securityStationId.hashCode());
        String $securityStationName = this.getSecurityStationName();
        result = result * 59 + ($securityStationName == null ? 43 : $securityStationName.hashCode());
        String $securityStationAddress = this.getSecurityStationAddress();
        result = result * 59 + ($securityStationAddress == null ? 43 : $securityStationAddress.hashCode());
        String $superviseDepartId = this.getSuperviseDepartId();
        result = result * 59 + ($superviseDepartId == null ? 43 : $superviseDepartId.hashCode());
        String $superviseDepartName = this.getSuperviseDepartName();
        result = result * 59 + ($superviseDepartName == null ? 43 : $superviseDepartName.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $contact = this.getContact();
        result = result * 59 + ($contact == null ? 43 : $contact.hashCode());
        PoliceEventStatus $policeEventStatus = this.getPoliceEventStatus();
        result = result * 59 + ($policeEventStatus == null ? 43 : $policeEventStatus.hashCode());
        PoliceEventCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        PoliceEventLevel $policeEventLevel = this.getPoliceEventLevel();
        result = result * 59 + ($policeEventLevel == null ? 43 : $policeEventLevel.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        GeoPointValueType $lonLat = this.getLonLat();
        result = result * 59 + ($lonLat == null ? 43 : $lonLat.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $actionTaken = this.getActionTaken();
        result = result * 59 + ($actionTaken == null ? 43 : $actionTaken.hashCode());
        String $actionTendency = this.getActionTendency();
        result = result * 59 + ($actionTendency == null ? 43 : $actionTendency.hashCode());
        String $processedSuggestion = this.getProcessedSuggestion();
        result = result * 59 + ($processedSuggestion == null ? 43 : $processedSuggestion.hashCode());
        String $processedLocaleGuidance = this.getProcessedLocaleGuidance();
        result = result * 59 + ($processedLocaleGuidance == null ? 43 : $processedLocaleGuidance.hashCode());
        String $processedUserId = this.getProcessedUserId();
        result = result * 59 + ($processedUserId == null ? 43 : $processedUserId.hashCode());
        String $processedUserName = this.getProcessedUserName();
        result = result * 59 + ($processedUserName == null ? 43 : $processedUserName.hashCode());
        String $sceneUrl = this.getSceneUrl();
        result = result * 59 + ($sceneUrl == null ? 43 : $sceneUrl.hashCode());
        Timestamp $processedTime = this.getProcessedTime();
        result = result * 59 + ($processedTime == null ? 43 : ((Object)$processedTime).hashCode());
        Timestamp $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        String $empName = this.getEmpName();
        result = result * 59 + ($empName == null ? 43 : $empName.hashCode());
        String $empIdNumber = this.getEmpIdNumber();
        result = result * 59 + ($empIdNumber == null ? 43 : $empIdNumber.hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        return result;
    }

    public String toString() {
        return "PoliceIncidentsEntity(id=" + this.getId() + ", tenantUserId=" + this.getTenantUserId() + ", tenantEmployeeId=" + this.getTenantEmployeeId() + ", organizationId=" + this.getOrganizationId() + ", organizationName=" + this.getOrganizationName() + ", securityStationId=" + this.getSecurityStationId() + ", securityStationName=" + this.getSecurityStationName() + ", securityStationAddress=" + this.getSecurityStationAddress() + ", superviseDepartId=" + this.getSuperviseDepartId() + ", superviseDepartName=" + this.getSuperviseDepartName() + ", code=" + this.getCode() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", contact=" + this.getContact() + ", policeEventStatus=" + this.getPoliceEventStatus() + ", category=" + this.getCategory() + ", policeEventLevel=" + this.getPoliceEventLevel() + ", policeEventType=" + this.getPoliceEventType() + ", address=" + this.getAddress() + ", reason=" + this.getReason() + ", lonLat=" + this.getLonLat() + ", location=" + this.getLocation() + ", actionTaken=" + this.getActionTaken() + ", actionTendency=" + this.getActionTendency() + ", processedSuggestion=" + this.getProcessedSuggestion() + ", processedLocaleGuidance=" + this.getProcessedLocaleGuidance() + ", processedUserId=" + this.getProcessedUserId() + ", processedUserName=" + this.getProcessedUserName() + ", sceneUrl=" + this.getSceneUrl() + ", processedTime=" + this.getProcessedTime() + ", createdTime=" + this.getCreatedTime() + ", empName=" + this.getEmpName() + ", empIdNumber=" + this.getEmpIdNumber() + ", projectId=" + this.getProjectId() + ", projectName=" + this.getProjectName() + ", calculatedResourceType=" + this.getCalculatedResourceType() + ")";
    }
}

