/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.open.domains.criterias.DispatchLogDetailSearchCriteria;
import com.bcxin.tenant.open.domains.criterias.MyDispatchLogRecordCriteria;
import com.bcxin.tenant.open.domains.entities.DeviceCommunicatedLogDetailEntity;
import com.bcxin.tenant.open.domains.mappers.DeviceCommunicatedLogDetailMapper;
import com.bcxin.tenant.open.domains.repositories.DeviceCommunicatedLogDetailRepository;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class DeviceCommunicatedLogDetailRepositoryImpl
implements DeviceCommunicatedLogDetailRepository {
    private final DeviceCommunicatedLogDetailMapper deviceCommunicatedLogDetailMapper;

    public DeviceCommunicatedLogDetailRepositoryImpl(DeviceCommunicatedLogDetailMapper deviceCommunicatedLogDetailMapper) {
        this.deviceCommunicatedLogDetailMapper = deviceCommunicatedLogDetailMapper;
    }

    public DeviceCommunicatedLogDetailEntity getById(Object id) {
        return (DeviceCommunicatedLogDetailEntity)this.deviceCommunicatedLogDetailMapper.selectById((Long)id);
    }

    public void insert(DeviceCommunicatedLogDetailEntity data) {
        this.deviceCommunicatedLogDetailMapper.insert(data);
    }

    public void update(DeviceCommunicatedLogDetailEntity data) {
        this.deviceCommunicatedLogDetailMapper.updateById(data);
    }

    public EntityCollection<DeviceCommunicatedLogDetailEntity> search(DispatchLogDetailSearchCriteria criteria) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        boolean validQuery = false;
        if (StringUtils.hasLength((String)criteria.getLogId())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.eq(DeviceCommunicatedLogDetailEntity::getDeviceCommunicatedLogId, (Object)criteria.getLogId());
            validQuery = true;
        }
        if (StringUtils.hasLength((String)criteria.getCalledOrganizationId())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.eq(DeviceCommunicatedLogDetailEntity::getCalledDomainId, (Object)criteria.getCalledOrganizationId());
            validQuery = true;
        }
        if (criteria.getReferenceType() != null) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.eq(DeviceCommunicatedLogDetailEntity::getReferenceType, (Object)criteria.getReferenceType().ordinal());
            validQuery = true;
        }
        if (StringUtils.hasLength((String)criteria.getReferenceNumber())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.eq(DeviceCommunicatedLogDetailEntity::getReferenceNumber, (Object)criteria.getReferenceNumber());
            validQuery = true;
        }
        if (!validQuery) {
            return EntityCollection.EMPTY();
        }
        if (criteria.isIgnoreCount()) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.orderByAsc(DeviceCommunicatedLogDetailEntity::getCreatedTime);
            List data = this.deviceCommunicatedLogDetailMapper.selectList((Wrapper)queryWrapper);
            return EntityCollection.create((Collection)data, (int)criteria.getPageSize(), (Long)Long.valueOf(data.size()));
        }
        int pageIndex = criteria.getPageIndex();
        if (pageIndex <= 0) {
            pageIndex = 1;
        }
        Page page = new Page((long)pageIndex, (long)criteria.getPageSize());
        queryWrapper = (LambdaQueryWrapper)queryWrapper.orderByAsc(DeviceCommunicatedLogDetailEntity::getCreatedTime);
        IPage data = this.deviceCommunicatedLogDetailMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return EntityCollection.create((Collection)data.getRecords(), (int)criteria.getPageSize(), (Long)data.getTotal());
    }

    public void batchInsert(Collection<DeviceCommunicatedLogDetailEntity> logs) {
        logs.forEach(ix -> this.deviceCommunicatedLogDetailMapper.insert(ix));
    }

    public DeviceCommunicatedLogDetailEntity getByNoPkId(String id) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(DeviceCommunicatedLogDetailEntity::getId, (Object)id);
        return (DeviceCommunicatedLogDetailEntity)this.deviceCommunicatedLogDetailMapper.selectOne((Wrapper)lambdaQueryWrapper);
    }

    public Collection<DeviceCommunicatedLogDetailEntity> search(MyDispatchLogRecordCriteria criteria) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(DeviceCommunicatedLogDetailEntity::getCalledUserId, (Object)criteria.getEmployeeId());
        if (criteria.getBeginDate() != null) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.ge(DeviceCommunicatedLogDetailEntity::getCreatedTime, (Object)criteria.getBeginDate());
        }
        if (criteria.getEndDate() != null) {
            Date endDate = criteria.getEndDate();
            Calendar endDateCalender = Calendar.getInstance();
            endDateCalender.setTime(endDate);
            endDateCalender.add(5, 1);
            endDate = endDateCalender.getTime();
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.lt(DeviceCommunicatedLogDetailEntity::getCreatedTime, (Object)endDate);
        }
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.last(String.format("limit %s,%s", criteria.getSkip(), criteria.getPageSize()));
        return this.deviceCommunicatedLogDetailMapper.selectList((Wrapper)lambdaQueryWrapper);
    }
}

