/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.open.domains.criterias.RdSecurityStationRailMessageCriteria;
import com.bcxin.tenant.open.domains.entities.RdSecurityStationRailMessageEntity;
import com.bcxin.tenant.open.domains.mappers.RdSecurityStationRailMessageMapper;
import com.bcxin.tenant.open.domains.repositories.RdSecurityStationRailMessageRepository;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import com.bcxin.tenant.open.infrastructures.utils.DateUtils;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class RdSecurityStationRailMessageRepositoryImpl
implements RdSecurityStationRailMessageRepository {
    private final RdSecurityStationRailMessageMapper rdSecurityStationRailMessageMapper;

    public RdSecurityStationRailMessageRepositoryImpl(RdSecurityStationRailMessageMapper rdSecurityStationRailMessageMapper) {
        this.rdSecurityStationRailMessageMapper = rdSecurityStationRailMessageMapper;
    }

    public RdSecurityStationRailMessageEntity getById(Object id) {
        RdSecurityStationRailMessageEntity message = (RdSecurityStationRailMessageEntity)this.rdSecurityStationRailMessageMapper.selectById((Serializable)id);
        return message;
    }

    public void insert(RdSecurityStationRailMessageEntity data) {
        this.rdSecurityStationRailMessageMapper.insert(data);
    }

    public void update(RdSecurityStationRailMessageEntity data) {
        this.rdSecurityStationRailMessageMapper.updateById(data);
    }

    public void insertAll(Collection<RdSecurityStationRailMessageEntity> messages) {
        if (CollectionUtils.isEmpty(messages)) {
            return;
        }
        messages.forEach(mg -> this.rdSecurityStationRailMessageMapper.insert(mg));
    }

    public EntityCollection<RdSecurityStationRailMessageEntity> search(RdSecurityStationRailMessageCriteria criteria) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = !CollectionUtils.isEmpty((Collection)criteria.getCurrentSuperviseDepartIds()) ? (LambdaQueryWrapper)lambdaQueryWrapper.in(RdSecurityStationRailMessageEntity::getRailReferenceSuperviseDepartId, criteria.getCurrentSuperviseDepartIds()) : (LambdaQueryWrapper)lambdaQueryWrapper.in(RdSecurityStationRailMessageEntity::getOrganizationId, criteria.getOrganizationIds());
        if (StringUtils.hasLength((String)criteria.getEmployeeName())) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.likeRight(RdSecurityStationRailMessageEntity::getEmployeeName, (Object)criteria.getEmployeeName());
        }
        if (StringUtils.hasLength((String)criteria.getCompanyName())) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.likeRight(RdSecurityStationRailMessageEntity::getCompanyName, (Object)criteria.getCompanyName());
        }
        if (StringUtils.hasLength((String)criteria.getRailReferenceName())) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.likeRight(RdSecurityStationRailMessageEntity::getRailReferenceName, (Object)criteria.getRailReferenceName());
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getSuperviseDepartIds())) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.in(RdSecurityStationRailMessageEntity::getRailReferenceSuperviseDepartId, criteria.getSuperviseDepartIds());
        }
        if (criteria.getEventStartDate() != null) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.ge(RdSecurityStationRailMessageEntity::getEventTime, (Object)criteria.getEventStartDate());
        }
        if (criteria.getEventEndDate() != null) {
            Timestamp endTime = DateUtils.getSpecialDayEndTimestamp((Date)criteria.getEventEndDate());
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.le(RdSecurityStationRailMessageEntity::getEventTime, (Object)endTime);
        }
        if (StringUtils.hasLength((String)criteria.getEmployeeIdCardNo())) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.likeRight(RdSecurityStationRailMessageEntity::getEmployeeIdCardNo, (Object)criteria.getEmployeeIdCardNo());
        }
        if (criteria.getDeskTypes() != null) {
            int calculatedResourceTypeValue = ResourceType.getCalculatedResourceValueByDeskTypes((Collection)criteria.getDeskTypes());
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.apply("calculated_resource_type&" + calculatedResourceTypeValue + ">0", new Object[0]);
        }
        if (StringUtils.hasLength((String)criteria.getEmployeeName())) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.likeRight(RdSecurityStationRailMessageEntity::getEmployeeName, (Object)criteria.getEmployeeName());
        }
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.orderByDesc(RdSecurityStationRailMessageEntity::getCreatedTime);
        if (!criteria.ignorePage()) {
            Page page = new Page((long)criteria.getPageIndex(), (long)criteria.getPageSize());
            IPage securityStationRailMessageEntityIPage = this.rdSecurityStationRailMessageMapper.selectPage((IPage)page, (Wrapper)lambdaQueryWrapper);
            return EntityCollection.create((Collection)securityStationRailMessageEntityIPage.getRecords(), (int)criteria.getPageSize(), (Long)securityStationRailMessageEntityIPage.getTotal());
        }
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.last(String.format("limit %s, %s ", criteria.getSkip(), criteria.getPageSize()));
        List securityStationRailMessageEntityIPage = this.rdSecurityStationRailMessageMapper.selectList((Wrapper)lambdaQueryWrapper);
        return EntityCollection.createForNoTotalCount((Collection)securityStationRailMessageEntityIPage, (int)criteria.getPageSize());
    }
}

