/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bcxin.tenant.open.domains.entities.RdDeviceLocationHistoryEntity;
import com.bcxin.tenant.open.domains.mappers.RdDeviceLocationHistoryMapper;
import com.bcxin.tenant.open.domains.repositories.RdDeviceLocationHistoryRepository;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.springframework.stereotype.Repository;

@Repository
public class RdDeviceLocationHistoryRepositoryImpl
implements RdDeviceLocationHistoryRepository {
    private final RdDeviceLocationHistoryMapper deviceLocationHistoryMapper;

    public RdDeviceLocationHistoryRepositoryImpl(RdDeviceLocationHistoryMapper deviceLocationHistoryMapper) {
        this.deviceLocationHistoryMapper = deviceLocationHistoryMapper;
    }

    public RdDeviceLocationHistoryEntity getById(Object id) {
        return (RdDeviceLocationHistoryEntity)this.deviceLocationHistoryMapper.selectById((Serializable)id);
    }

    public void insert(RdDeviceLocationHistoryEntity data) {
        this.deviceLocationHistoryMapper.insert(data);
    }

    public void update(RdDeviceLocationHistoryEntity data) {
        this.deviceLocationHistoryMapper.updateById(data);
    }

    public Collection<RdDeviceLocationHistoryEntity> getLocations(String deviceId, Date beginDate, Date endDate) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper = (LambdaQueryWrapper)queryWrapper.eq(RdDeviceLocationHistoryEntity::getDeviceId, (Object)deviceId);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (beginDate != null) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.ge(RdDeviceLocationHistoryEntity::getCreatedTime, (Object)dateFormat.format(beginDate));
        }
        if (endDate != null) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.lt(RdDeviceLocationHistoryEntity::getCreatedTime, (Object)dateFormat.format(endDate));
        }
        return this.deviceLocationHistoryMapper.selectList((Wrapper)queryWrapper);
    }
}

