/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument$;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument$;
import com.bcxin.tenant.open.document.domains.dtos.RdCompanyCountOfSecurityManDTO;
import com.bcxin.tenant.open.document.domains.dtos.RdCompanyCountOfStationDTO;
import com.bcxin.tenant.open.domains.criterias.ProjectRoadmapCriteria;
import com.bcxin.tenant.open.domains.dtos.ProjectRoadmapDTO;
import com.bcxin.tenant.open.domains.dtos.SecurityStationSuperviseDTO;
import com.bcxin.tenant.open.domains.mappers.RdDeviceDeskServiceScopeViewMapper;
import com.bcxin.tenant.open.domains.mappers.RdProjectRoadmapMapper;
import com.bcxin.tenant.open.domains.mappers.RdSecurityStationPersonMapper;
import com.bcxin.tenant.open.domains.mappers.RdTenantUserAccountViewMapper;
import com.bcxin.tenant.open.domains.readers.RdCompositedReader;
import com.bcxin.tenant.open.domains.views.RdDeviceDeskServiceScopeView;
import com.bcxin.tenant.open.domains.views.RdTenantUserAccountView;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.predicates.SearchFieldPredicate;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;

@Repository
public class RdCompositedReaderImpl
implements RdCompositedReader {
    private final RdTenantUserAccountViewMapper tenantUserAccountViewMapper;
    private final RdDeviceDeskServiceScopeViewMapper deviceDeskServiceScopeViewMapper;
    private final RdSecurityStationPersonMapper securityStationPersonMapper;
    private final EntityStream entityStream;
    private final RdProjectRoadmapMapper projectRoadmapMapper;

    public RdCompositedReaderImpl(RdTenantUserAccountViewMapper tenantUserAccountViewMapper, RdDeviceDeskServiceScopeViewMapper deviceDeskServiceScopeViewMapper, RdSecurityStationPersonMapper securityStationPersonMapper, EntityStream entityStream, RdProjectRoadmapMapper projectRoadmapMapper) {
        this.tenantUserAccountViewMapper = tenantUserAccountViewMapper;
        this.deviceDeskServiceScopeViewMapper = deviceDeskServiceScopeViewMapper;
        this.securityStationPersonMapper = securityStationPersonMapper;
        this.entityStream = entityStream;
        this.projectRoadmapMapper = projectRoadmapMapper;
    }

    public Collection<RdDeviceDeskServiceScopeView> getByEmployeeIds(Collection<String> employeeIds) {
        return this.deviceDeskServiceScopeViewMapper.getByBoundEmployeeIds(employeeIds);
    }

    public RdTenantUserAccountView getUserById(String tenantUserId) {
        return this.tenantUserAccountViewMapper.getUserById(tenantUserId);
    }

    public Collection<SecurityStationSuperviseDTO> getValidSecurityStationSupervisesByEmployeeIds(Collection<String> employeeIds) {
        return this.securityStationPersonMapper.getAllValidSecurityStationsByEmployeeIds(employeeIds);
    }

    public Long getCountOfSecurityManByOrganizationId(String organizationId) {
        Long countOfSecurityMan = this.entityStream.of(RdEmployeeDocument.class).filter((SearchFieldPredicate)RdEmployeeDocument$.ORGANIZATION_ID.eq((Object)organizationId)).count();
        return countOfSecurityMan;
    }

    public Long getCountOfSecurityManByStationId(String stationId) {
        Long countOfSecurityMan = this.entityStream.of(RdEmployeeDocument.class).filter((SearchFieldPredicate)RdEmployeeDocument$.SECURITY_STATION_ID.eq((Object)stationId)).count();
        return countOfSecurityMan;
    }

    public Long getCountOfActivityStationByOrganizationId(String organizationId) {
        Long countOfActivityStation = this.entityStream.of(RdSecurityStationDocument.class).filter((SearchFieldPredicate)RdSecurityStationDocument$.ORGANIZATION_ID.eq((Object)organizationId)).filter((SearchFieldPredicate)RdSecurityStationDocument$.IS_ACTIVATED.eq((Object)true)).count();
        return countOfActivityStation;
    }

    public Collection<RdCompanyCountOfSecurityManDTO> getCountOfSecurityManByOrganizationIds(Collection<String> organizationIds) {
        String[] organizationIdsArray = organizationIds.toArray(new String[organizationIds.size()]);
        return organizationIds.stream().map(ii -> {
            Long count = this.entityStream.of(RdEmployeeDocument.class).filter((SearchFieldPredicate)RdEmployeeDocument$.ORGANIZATION_ID.in(organizationIdsArray)).count();
            RdCompanyCountOfSecurityManDTO dto = new RdCompanyCountOfSecurityManDTO();
            dto.setOrganizationId(ii);
            dto.setTotal(count);
            return dto;
        }).collect(Collectors.toList());
    }

    public Collection<RdCompanyCountOfStationDTO> getCountOfStationByOrganizationIds(Collection<String> organizationIds) {
        String[] organizationIdsArray = organizationIds.toArray(new String[organizationIds.size()]);
        return organizationIds.stream().map(ii -> {
            RdCompanyCountOfStationDTO dto = new RdCompanyCountOfStationDTO();
            dto.setOrganizationId(ii);
            Long count = this.entityStream.of(RdSecurityStationDocument.class).filter((SearchFieldPredicate)RdSecurityStationDocument$.ORGANIZATION_ID.in(organizationIdsArray)).filter((SearchFieldPredicate)RdSecurityStationDocument$.IS_ACTIVATED.eq((Object)true)).count();
            dto.setTotal(count);
            return dto;
        }).collect(Collectors.toList());
    }

    public EntityCollection<ProjectRoadmapDTO> search(ProjectRoadmapCriteria criteria) {
        Collection<ProjectRoadmapDTO> roadmaps = this.projectRoadmapMapper.search(criteria);
        long totalCount = this.projectRoadmapMapper.getTotalCount(criteria);
        return EntityCollection.create(roadmaps, (int)criteria.getPageSize(), (Long)totalCount);
    }

    public Collection<RdDeviceDeskServiceScopeView> getSuperiorDeskByBoundEmployeeIds(Collection<String> employeeIds) {
        return this.deviceDeskServiceScopeViewMapper.getSuperiorDeskByBoundEmployeeIds(employeeIds);
    }
}

