package com.bcxin.tenant.open.document.domains.utils;

import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument$;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import org.ansj.domain.Term;
import org.ansj.splitWord.analysis.BaseAnalysis;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.stream.Collectors;

public class KeywordTermUtils {
    public static String getFilterExpression(String searchKeyword) {
        /**
         * https://blog.csdn.net/Charles_Timber/article/details/106138102
         * 可以满足”奥森公园的搜索“
         */
        Collection<Term> terms =
                BaseAnalysis.parse(StringUtil.formatFullText(searchKeyword, true)).getTerms();

        Collection<String> keyTerms = terms.stream().map(ii -> ii.getName())
                .filter(ii -> StringUtils.hasLength(ii) && ii.trim().length() > 0)
                .collect(Collectors.toList());

        Collection<String> keywordTerms = keyTerms.stream().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(keywordTerms)) {
            String keyword = keywordTerms.stream().collect(Collectors.joining("**"));


            String filterExpression = String.format("(*%s*)|(@%s:{%s*})",
                    keyword,
                    RdSecurityStationDocument$.name.getName(),
                    StringUtil.formatFullText(searchKeyword, false)
            );

            return filterExpression;
        }

        /**
         * 需要加两个*;否则, 无法查询
         */
        String keyword = keyTerms.stream().collect(Collectors.joining("**"));

        return "*".concat(keyword).concat("*");
    }
}
