package com.bcxin.tenant.open.document.domains.utils;

import com.bcxin.tenant.open.infrastructures.constants.BusinessConstants;
import com.bcxin.tenant.open.infrastructures.utils.LonLatValueTypeUtils;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.infrastructures.valueTypes.GeoLocationValueType;
import com.bcxin.tenant.open.infrastructures.valueTypes.LonLatValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.geo.Point;

public class GeoPointUtils {
    private static final Logger logger = LoggerFactory.getLogger(GeoPointUtils.class);
    private static final String LNG_PATTERN = "^[\\-\\+]?(0(\\.\\d{1,6})?|([1-9](\\d)?)(\\.\\d{1,6})?|1[0-7]\\d{1}(\\.\\d{1,6})?|180(\\.0{1,6})?)$";
    private static final String LAT_PATTERN = "^[\\-\\+]?((0|([1-8]\\d?))(\\.\\d{1,6})?|90(\\.0{1,6})?)$";
    public static Point translate(String lonLatString) {
        if(!StringUtil.isEmpty(lonLatString)) {
            try {
                LonLatValueType lonLatValue = LonLatValueTypeUtils.translate(lonLatString);
                if (lonLatValue != null &&
                        lonLatValue.getLat() != null &&
                        lonLatValue.getLon() != null &&
                        lonLatValue.getLat() > 1.0) {
                    double lonValue = lonLatValue.getLon();
                    double latValue = lonLatValue.getLat();
                    /**
                     * 摆渡上获取到的数据: 24.834037,118.200913
                     * 存储方式为: #{"lat":118.200913,"lon":24.834037}
                     * Latitude: 维度
                     * Longitude: 经度
                     */
                    Point lonLat = new Point(lonValue, latValue);
                    return lonLat;
                }
            } catch (Exception ex) {
                logger.error("当前经纬度信息无效:{}", lonLatString, ex);
            }
        }

        return new Point(BusinessConstants.INVALID_LON_LAT, BusinessConstants.INVALID_LON_LAT);
    }

    public static boolean IsValidGeo(Double lon,Double lat) {
        if (lon == null || lat == null) {
            return false;
        }

        try {
            Point lonLat = new Point(lon, lat);
            return true;
        } catch (Exception ex) {
            logger.error("当前经纬度信息无效:{},{}", lon, lat, ex);
        }

        return false;
    }

    /**
     * 针对无效的经纬度的时候, 返回空
     * @param lon
     * @param lat
     * @return
     */
    public static Point translateFromLocation(double lon,double lat) {
        try {
            return new Point(lon, lat);
        } catch (Exception ex) {
            logger.error("经纬度的转换失败:{}, {}", lon, lat);
        }

        return null;
    }
}
