package com.bcxin.tenant.open.document.domains.utils;

import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument$;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument$;
import com.bcxin.tenant.open.infrastructures.constants.BusinessConstants;
import com.bcxin.tenant.open.infrastructures.enums.RoleType;
import com.bcxin.tenant.open.infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.redis.om.spring.search.stream.SearchStream;
import org.springframework.util.CollectionUtils;

import java.util.Collection;

public class DocumentScopeFilterUtils {
    public static SearchStream<RdEmployeeDocument> basicFilterEmployee(
            SearchStream<RdEmployeeDocument> documentSearchStream,
            String orgInstitutional, String orgId,
            String orgName,
            Collection<String> superviseDepartIds) {
        if (BusinessUtil.isSupervise(orgInstitutional)) {
            if (CollectionUtils.isEmpty(superviseDepartIds)) {
                throw new ArgumentTenantException("监管组织-监管的调度范围不能为空");
            }
            String[] scopeIds = superviseDepartIds.toArray(ix -> new String[ix]);
            documentSearchStream =
                    documentSearchStream.filter(RdEmployeeDocument$.SCOPE_PERMISSIONS.in(scopeIds));
        } else {
            if (StringUtil.isEmpty(orgId)) {
                throw new ArgumentTenantException("企业组织-组织Id不能为空");
            }

            documentSearchStream = documentSearchStream
                    .filter(RdEmployeeDocument$.SCOPE_PERMISSIONS.in(orgId));
            RoleType roleType = RoleType.create(orgInstitutional, orgName);
            if (roleType == RoleType.Company) {
                String[] excludeValues = new String[]{
                        BusinessConstants.DefaultEmptyValue
                };

                documentSearchStream = documentSearchStream
                        .filter(RdEmployeeDocument$.SECURITY_STATION_ID.notEq(excludeValues));
            }
        }

        return documentSearchStream;
    }

    public static SearchStream<RdSecurityStationDocument> basicFilterStation(
            SearchStream<RdSecurityStationDocument> documentSearchStream,
            String orgInstitutional, String orgId,
            Collection<String> superviseDepartIds) {
        if (BusinessUtil.isSupervise(orgInstitutional)) {
            if (CollectionUtils.isEmpty(superviseDepartIds)) {
                throw new ArgumentTenantException("监管组织-监管的调度范围不能为空");
            }
            String[] scopeIds = superviseDepartIds.toArray(ix -> new String[ix]);
            documentSearchStream =
                    documentSearchStream.filter(RdSecurityStationDocument$.SCOPE_PERMISSIONS.in(scopeIds));
        } else {
            if (StringUtil.isEmpty(orgId)) {
                throw new ArgumentTenantException("企业组织-组织Id不能为空");
            }

            documentSearchStream = documentSearchStream.filter(RdSecurityStationDocument$.SCOPE_PERMISSIONS.in(orgId));
        }

        return documentSearchStream;
    }
}
