package com.bcxin.tenant.open.document.domains.documents.messages;

import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import lombok.Data;

import java.sql.Timestamp;
import java.time.Instant;

@Data
public class RoomUserActiveMessageContentDocument extends MessageContentDocumentAbstract{
    private Long id;
    private String employeeId;

    /**
     * 调度人Id
     */
    private String userId;

    private String tencentUserId;

    private String name;

    private String organizationId;

    private String type;

    private String yardmanType;

    private String roomNo;

    private Timestamp createdTime;

    public RoomUserActiveMessageContentDocument() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static RoomUserActiveMessageContentDocument create(Long id,
                                                String callerTencentUserId,
                                                String employeeId,
                                                String tencentUserId,
                                                String calledEmpName,
                                                String organizationId,
                                                 String roomNo,
                                                CommunicatedType communicatedType,
                                                int yardmanType
    ) {
        RoomUserActiveMessageContentDocument document = new RoomUserActiveMessageContentDocument();
        document.setUserId(callerTencentUserId);
        document.setYardmanType(String.valueOf(yardmanType));
        document.setRoomNo(roomNo);
        document.setName(calledEmpName);
        document.setType(communicatedType == null ? null : communicatedType.name().toLowerCase());


        document.setId(id);
        document.setOrganizationId(organizationId);
        document.setEmployeeId(employeeId);
        document.setTencentUserId(tencentUserId);
        return document;
    }
}
