package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.enums.DispatchReasonType;
import com.bcxin.tenant.open.infrastructures.enums.RoomUserStatus;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;

@Document(language = SearchLanguage.CHINESE,timeToLive = 12*60*60)
@Data
public class RoomDocument extends EntityAbstract {
    @Id
    @Indexed
    private Long id;
    private String organizationId;
    private String employeeId;
    private Boolean activated;
    private DeskType deskType;
    private Timestamp leaveTime;
    private Timestamp createdTime;

    private  CommunicatedType communicatedType;
    private int yardmanType;

    /**
     * 调度原因
     */
    private DispatchReasonType referenceType;

    /**
     * 调度的引用Id
     */
    private String referenceNumber;

    private Collection<RoomUserDocument> roomUsers;

    public RoomDocument() {
        this.setActivated(true);
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static RoomDocument create(Long id,
                                      DeskType deskType,
                                      String organizationId,
                                      String employeeId,
                                      CommunicatedType communicatedType,
                                      int yardmanType,
                                      DispatchReasonType referenceType,
                                      String referenceNumber,
                                      Collection<RoomUserDocument> roomUsers) {
        RoomDocument document = new RoomDocument();
        document.setId(id);
        document.setEmployeeId(employeeId);
        document.setOrganizationId(organizationId);
        document.setCommunicatedType(communicatedType);
        document.setYardmanType(yardmanType);

        document.setDeskType(deskType);
        document.setReferenceType(referenceType);
        document.setReferenceNumber(referenceNumber);

        document.setRoomUsers(roomUsers);

        return document;
    }


    public void leave() {
        this.setActivated(false);
        this.setLeaveTime(Timestamp.from(Instant.now()));
    }

    @Data
    public static class RoomUserDocument extends EntityAbstract {
        private String employeeId;
        private String tenantUserId;
        private String employeeName;
        private String organizationId;
        private String organizationName;
        private String tencentUserId;
        private String securityStationId;
        private String securityStationName;
        private String superviseDepartId;
        private String cid;
        private boolean isSponsor;

        public static RoomUserDocument create(String employeeId,
                                              String tenantUserId,
                                              String employeeName,
                                              String organizationId,
                                              String organizationName,
                                              String tencentUserId,
                                              String securityStationId,
                                              String securityStationName,
                                              String superviseDepartId,
                                              String cid,
                                              boolean isSponsor
        ) {
            RoomUserDocument document = new RoomUserDocument();
            document.setOrganizationId(organizationId);
            document.setSponsor(isSponsor);
            document.setEmployeeId(employeeId);
            document.setEmployeeName(employeeName);
            document.setSuperviseDepartId(superviseDepartId);
            document.setOrganizationName(organizationName);
            document.setTencentUserId(tencentUserId);
            document.setSecurityStationId(securityStationId);
            document.setSecurityStationName(securityStationName);
            document.setCid(cid);
            document.setTenantUserId(tenantUserId);

            return document;
        }
    }
}
