package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;

@Document(language = SearchLanguage.CHINESE,timeToLive = 5*60)
@Data
public class RollCallProgressStatusDocument extends EntityAbstract {
    @Id
    @Indexed
    private Long id;

    private int countOfMembers;

    private int countOfProcessed;

    public static RollCallProgressStatusDocument create(Long id, int countOfMembers) {
        RollCallProgressStatusDocument document = new RollCallProgressStatusDocument();
        document.setId(id);
        document.setCountOfMembers(countOfMembers);
        document.setCountOfProcessed(0);

        return document;
    }

    public void incrProcessed(int count) {
        this.setCountOfProcessed(this.getCountOfProcessed() + count);
    }
}
