package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.geo.Point;

import java.util.Set;

@Document(language = SearchLanguage.CHINESE)
@Data
public class RdWorkstationDocument extends EntityAbstract {
    @Id
    @Indexed
    private String id;

    /**
     * 工作点
     */
    private String displayName;

    /**
     * 执行范围(用于判断签到)
     */
    private Double performRange;

    /**
     * 属于此点的权限范围: 一般为人员Id
     */
    @Indexed
    private Set<String> scopePermissions;

    @Indexed
    @GeoIndexed
    private Point lonLat;

    private String address;
}
