package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;

@Document(language = SearchLanguage.CHINESE)
@Data
public class RdSecurityStationPersonDocument extends EntityAbstract {
    @Id
    @Indexed
    private String id;

    private String employeeId;

    @Indexed
    private String securityStationId;

    private String organizationId;

    public RdSecurityStationPersonDocument() {
    }

    public static RdSecurityStationPersonDocument create(
            String id, String employeeId,
            String securityStationId,
            String organizationId) {
        RdSecurityStationPersonDocument document = new RdSecurityStationPersonDocument();
        document.setId(id);
        document.setSecurityStationId(securityStationId);
        document.setEmployeeId(employeeId);
        document.setOrganizationId(organizationId);

        return document;
    }
}
