package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.valueTypes.ValueTypeAbstract;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.util.StringUtils;

import java.sql.Timestamp;
import java.util.Collection;

/**
 * 调度设备缓存信息 缓存30分钟
 */
@Document(language = SearchLanguage.CHINESE,timeToLive = 5 * 60)
@Data
public class RdDeviceDeskPermissionDocument extends EntityAbstract {
    @Id
    @Indexed
    private String employeeId;

    private Collection<RdDeviceDeskServiceScopeValueType> serviceScopes;

    private Collection<String> responsibleOfStationIds;

    public RdDeviceDeskPermissionDocument() {
    }

    public RdDeviceDeskPermissionDocument(String employeeId,
                                          Collection<String> responsibleOfStationIds,
                                          Collection<RdDeviceDeskServiceScopeValueType> serviceScopes) {
        this.serviceScopes = serviceScopes;
        this.employeeId = employeeId;
        this.responsibleOfStationIds = responsibleOfStationIds;
    }

    public static RdDeviceDeskPermissionDocument create(String employeeId,
                                                        Collection<String> responsibleOfStationIds,
                                                        Collection<RdDeviceDeskServiceScopeValueType> serviceScopes) {
        return new RdDeviceDeskPermissionDocument(employeeId, responsibleOfStationIds, serviceScopes);
    }

    /**
     * 调度范围
     */
    @Data
    public static class RdDeviceDeskServiceScopeValueType extends ValueTypeAbstract {
        private String id;

        /**
         * 调度台
         */
        private String name;
        /**
         * 腾讯的资源号
         */
        private String number;
        /**
         * 有效期开始时间
         */
        private Timestamp beginDate;
        /**
         * 有效期结束时间
         */
        private Timestamp endDate;
        /**
         * 被绑定的人
         */
        private String boundEmployeeId;

        /**
         * 被授权的监管归属的部门Id
         */
        private String assignedSuperviseDepartId;

        /**
         * ipAddress
         */
        private String ipAddress;

        /**
         * 组织Id
         */
        private String orgId;

        private String desc;

        /**
         * 是否来自附加的派出所信息
         */
        private byte ir=0;

        public RdDeviceDeskServiceScopeValueType() {
        }

        public RdDeviceDeskServiceScopeValueType(String id,
                                                 String name,
                                                 String number,
                                                 Timestamp beginDate, Timestamp endDate,
                                                 String boundEmployeeId,
                                                 String assignedSuperviseDepartId,
                                                 String ipAddress,
                                                 String orgId,
                                                 String desc
        ) {
            this.id = id;
            this.name = name;
            this.number = number;
            this.beginDate = beginDate;
            this.endDate = endDate;
            this.boundEmployeeId = boundEmployeeId;
            this.assignedSuperviseDepartId = assignedSuperviseDepartId;
            this.ipAddress = ipAddress;
            this.orgId = orgId;
            this.desc =desc;
        }

        public static RdDeviceDeskServiceScopeValueType create(String id,
                                                               String name,
                                                               String number,
                                                               Timestamp beginDate, Timestamp endDate,
                                                               String boundEmployeeId,
                                                               String assignedSuperviseDepartId,
                                                               String ipAddress,
                                                               String orgId,
                                                               String desc) {
            return new RdDeviceDeskServiceScopeValueType(id,
                    name,
                    number, beginDate, endDate,
                    boundEmployeeId, assignedSuperviseDepartId, ipAddress,
                    orgId,desc);
        }

        public RdDeviceDeskServiceScopeValueType copy(String superviseDepartId,boolean fromIr,String nameStuff) {
            /**
             * 拷贝的时候; 不能直接设置拷贝Id, 因为这个ID是调度台Id, 因此,都是一样的.
             * 搜索的时候; 针对派出所, 我们会根据该值来进行搜索
             * public Collection<String> getRelativeSameSelectedDepartIds(Collection<String> departIds) {
             */
            String newName = name;
            if(StringUtils.hasLength(nameStuff)) {
                newName = String.format("%s-%s", name, nameStuff);
            }

            RdDeviceDeskServiceScopeValueType copy =
                    new RdDeviceDeskServiceScopeValueType(
                    this.getAssignedSuperviseDepartId(),
                            newName,
                    number,
                    beginDate,
                    endDate,
                    boundEmployeeId,
                    superviseDepartId,
                    ipAddress,
                    orgId,desc);

            if(fromIr)
            {
                copy.setIr((byte) 1);
            }else{
                copy.setIr((byte) 0);
            }

            return copy;
        }
    }
}
