package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.sql.Timestamp;
import java.time.Instant;

/**
 * 企业的联动值信息
 */
@Document(language = SearchLanguage.CHINESE,timeToLive = 10 * 60)
@Data
public class OrgPurseDocument  extends EntityAbstract {
    @Id
    @Indexed
    private String id;

    private Long points;

    private boolean dispatchable;

    private boolean fADT;

    private Timestamp lst;

    public static OrgPurseDocument create(String id, long points, boolean dispatchable, boolean fADT) {
        OrgPurseDocument document = new OrgPurseDocument();
        document.setId(id);
        document.setPoints(points);
        document.setDispatchable(dispatchable);
        document.setLst(Timestamp.from(Instant.now()));
        document.setFADT(fADT);

        return document;
    }
}
