package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.document.domains.documents.messages.MessageContentDocumentAbstract;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.NotifyMessageType;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import lombok.Data;
import org.springframework.data.annotation.Id;

@Document(language = SearchLanguage.CHINESE,timeToLive = 5*60)
@Data
public class NotifyMessageDocument  extends EntityAbstract {
    @Id
    @Indexed
    private String id;

    @Indexed
    private String employeeId;

    @Indexed
    private String referenceNumber;

    private NotifyMessageType messageType;
    private String content;

    public static <T extends MessageContentDocumentAbstract> NotifyMessageDocument create(
            JsonProvider jsonProvider,
            NotifyMessageType messageType,
                                                      String id,
            /**
             * 业务ID; 比如: 房间号/RollCalLID
             */
            String referenceNumber,
            String employeeId, T data) {
        NotifyMessageDocument document = new NotifyMessageDocument();
        document.setId(id);
        document.setMessageType(messageType);
        document.setEmployeeId(employeeId);
        document.setContent(jsonProvider.getJson(data));
        document.setReferenceNumber(referenceNumber);

        return document;
    }
}
