package com.bcxin.tenant.open.document.domains.configs;

import com.redis.om.spring.annotations.EnableRedisDocumentRepositories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.repository.query.QueryLookupStrategy;

@Configuration
@EnableRedisDocumentRepositories(
        basePackages = "com.bcxin.tenant.open.document.domains",
        queryLookupStrategy = QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND
)
public class DocumentConfig implements CommandLineRunner, BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(DocumentConfig.class);

    @Override
    public void run(String... args) throws Exception {
        com.redis.om.spring.RediSearchIndexer rediSearchIndexer =
                this.beanFactory.getBean(com.redis.om.spring.RediSearchIndexer.class);

        logger.warn("DocumentConfig开始核对当前的索引是否存在-QueryLookupStrategy.Key.USE_DECLARED_QUERY");
        /*
        if (!rediSearchIndexer.indexExistsFor(RdCompanyDocument.class)) {
            rediSearchIndexer.createIndexFor(RdCompanyDocument.class);
            logger.warn("RdCompanyDocument 索引创建完毕");
        }

        if (!rediSearchIndexer.indexExistsFor(RdEmployeeDocument.class)) {
            rediSearchIndexer.createIndexFor(RdEmployeeDocument.class);
            logger.warn("RdEmployeeDocument 索引创建完毕");
        }

        if (!rediSearchIndexer.indexExistsFor(RdSecurityStationDocument.class)) {
            rediSearchIndexer.createIndexFor(RdSecurityStationDocument.class);
            logger.warn("RdSecurityStationDocument 索引创建完毕");
        }

         */
        logger.warn("完成所有的索引信息");
    }

    private BeanFactory beanFactory;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}
