/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.core;

import com.bcxin.flink.core.JdbcJobExecutorUtil;
import com.bcxin.flink.core.SystemPropertyUtil;
import com.bcxin.flink.core.properties.CheckpointConfigProperty;
import com.bcxin.flink.core.properties.CheckpointConfigPropertyBuilder;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.enums.JobType;
import com.bcxin.tenant.open.infrastructures.exceptions.NoFoundTenantException;
import com.bcxin.tenant.open.infrastructures.flinks.JobParameterDTO;
import com.bcxin.tenant.open.infrastructures.utils.PropertyUtils;
import java.io.IOException;
import java.util.Properties;

public abstract class AppAbstract {
    private static final String DATABASE_PROPERTY_CONF = "databasePropertyConf";

    protected static void initEnv(String[] args) throws IOException {
        String env = args[0];
        SystemPropertyUtil.loadEnvConf(env);
    }

    protected static CheckpointConfigProperty initCheckPointAndEnv(JsonProvider jsonProvider, String jobId) throws IOException {
        JobParameterDTO jobParameterDTO = AppAbstract.getJobParameter(jobId);
        if (jobParameterDTO == null) {
            throw new NoFoundTenantException("\u53c2\u6570\u65e0\u6548; \u65e0\u6cd5\u52a0\u8f7d\u5bf9\u5e94\u7684job\u53c2\u6570");
        }
        if (jobParameterDTO.getJobType() != JobType.WEBHOOK_API) {
            throw new IllegalArgumentException(String.format("\u8be5jobType(%s)\u4e0d\u652f\u6301\u6d41\u5904\u7406", jobParameterDTO.getJobType()));
        }
        String corePropertyConf = jobParameterDTO.getParam1(jsonProvider);
        String databasePropertyConf = jobParameterDTO.getParam2(jsonProvider);
        Properties properties = PropertyUtils.loadProperties((JsonProvider)jsonProvider, (String)corePropertyConf);
        properties.setProperty(DATABASE_PROPERTY_CONF, databasePropertyConf);
        CheckpointConfigProperty configProperty = CheckpointConfigPropertyBuilder.build(properties);
        return configProperty;
    }

    protected static JobParameterDTO getJobParameter(String jobId) {
        JobParameterDTO jobParameterDTO = JdbcJobExecutorUtil.getJobParameter(Integer.parseInt(jobId));
        if (jobParameterDTO == null) {
            throw new NoFoundTenantException(String.format("\u627e\u4e0d\u5230\u8be5\u914d\u7f6e\u9879:%s", jobId));
        }
        return jobParameterDTO;
    }

    protected static String getDatabasePropertyConfAfterInitEnv() {
        return System.getProperty(DATABASE_PROPERTY_CONF);
    }
}

