/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.core.dtos;

import com.bcxin.tenant.open.infrastructures.enums.OperatorType;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DebeziumJsonNodeDto
implements Serializable {
    private String op;
    private Long ts_ms;
    private JsonNode before;
    private JsonNode after;
    private JsonNode source;
    private String key;
    private Map<String, Object> _parameters;

    public OperatorType getOperatorType() {
        if (StringUtils.isEmpty((CharSequence)this.getOp())) {
            throw new IllegalArgumentException("\u65e0\u6548\u64cd\u4f5c\u7c7b\u578b");
        }
        switch (this.op) {
            case "d": {
                return OperatorType.DELETE;
            }
            case "u": {
                return OperatorType.UPDATE;
            }
        }
        return OperatorType.INSERT;
    }

    public static DebeziumJsonNodeDto create(String key, String op, Long ts_ms, JsonNode before, JsonNode after, JsonNode source) {
        DebeziumJsonNodeDto debeziumJsonNode = new DebeziumJsonNodeDto();
        debeziumJsonNode.setKey(key);
        debeziumJsonNode.setOp(op);
        debeziumJsonNode.setBefore(before);
        debeziumJsonNode.setAfter(after);
        debeziumJsonNode.setSource(source);
        return debeziumJsonNode;
    }

    public Map<String, Object> getParameters(String primaryKeyName) {
        if (this._parameters == null) {
            this._parameters = new HashMap<String, Object>();
            this._parameters = this.buildParameters(this._parameters, "before", this.getBefore());
            this._parameters = this.buildParameters(this._parameters, "after", this.getAfter());
            this._parameters = this.buildParameters(this._parameters, "source", this.getSource());
            this._parameters.put("op", this.getOp());
            this._parameters.put("key", this.getKey());
            this._parameters.put("ts_ms", this.getTs_ms());
            this._parameters.put(primaryKeyName, this.getKey());
        }
        return this._parameters;
    }

    private Map<String, Object> buildParameters(Map<String, Object> map, String prefix, JsonNode node) {
        Iterator iterator = node.fieldNames();
        if (iterator != null) {
            while (iterator.hasNext()) {
                String nodeKey;
                String key = nodeKey = (String)iterator.next();
                if (!StringUtils.isEmpty((CharSequence)prefix)) {
                    key = String.format("%s.%s", prefix, nodeKey);
                }
                JsonNode nodeValue = node.get(nodeKey);
                switch (nodeValue.getNodeType()) {
                    case NULL: {
                        map.put(key, null);
                        break;
                    }
                    case NUMBER: {
                        Date stamp;
                        if (nodeKey.toLowerCase().contains("time")) {
                            map.put(key, "2023-02-01 11:00:00");
                            break;
                        }
                        if (nodeKey.toLowerCase().contains("date")) {
                            stamp = new Date(nodeValue.asLong());
                            map.put(key, new Date());
                            break;
                        }
                        map.put(key, nodeValue.asDouble());
                        break;
                    }
                    case BOOLEAN: {
                        map.put(key, nodeValue.asBoolean());
                        break;
                    }
                    case STRING: 
                    case MISSING: 
                    case OBJECT: 
                    case ARRAY: 
                    case BINARY: 
                    case POJO: {
                        Date stamp;
                        if (nodeKey.toLowerCase().contains("time")) {
                            stamp = new Date(nodeValue.asLong());
                            map.put(key, "2023-02-01 11:00:00");
                            break;
                        }
                        if (nodeKey.toLowerCase().contains("date")) {
                            stamp = new Date(nodeValue.asLong());
                            map.put(key, new Date());
                            break;
                        }
                        map.put(key, nodeValue.asText());
                    }
                }
            }
        }
        return map;
    }

    public String getOp() {
        return this.op;
    }

    public Long getTs_ms() {
        return this.ts_ms;
    }

    public JsonNode getBefore() {
        return this.before;
    }

    public JsonNode getAfter() {
        return this.after;
    }

    public JsonNode getSource() {
        return this.source;
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, Object> get_parameters() {
        return this._parameters;
    }

    private void setOp(String op) {
        this.op = op;
    }

    private void setTs_ms(Long ts_ms) {
        this.ts_ms = ts_ms;
    }

    private void setBefore(JsonNode before) {
        this.before = before;
    }

    private void setAfter(JsonNode after) {
        this.after = after;
    }

    private void setSource(JsonNode source) {
        this.source = source;
    }

    private void setKey(String key) {
        this.key = key;
    }

    private void set_parameters(Map<String, Object> _parameters) {
        this._parameters = _parameters;
    }
}

