package com.bcxin.tenant.open.infrastructures.valueTypes;

import lombok.Data;

import java.util.Collection;
import java.util.stream.Collectors;

@Data
public class TrafficTagValueType extends ValueTypeAbstract {
    private Collection<String> tags;

    public static TrafficTagValueType create(Collection<String> tags){
        TrafficTagValueType valueType = new TrafficTagValueType();
        valueType.setTags(tags);

        return valueType;
    }

    public String getTagStringValue() {
        if (this.getTags() == null) {
            return null;
        }

        return this.getTags().stream().collect(Collectors.joining(","));
    }
}
