package com.bcxin.tenant.open.infrastructures.enums;

import java.util.Collection;

public enum DeskType {
    Normal {
        @Override
        public String getTypeName() {
            return "指挥调度台";
        }
    },
    Proprietor {
        @Override
        public String getTypeName() {
            return "内保调度台";
        }
    },
    TemporarySecurity {
        @Override
        public String getTypeName() {
            return "临保调度台";
        }
    };


    public static boolean hasDeskType(Collection<DeskType> deskTypes, DeskType expectedDeskType) {
        if (deskTypes == null) {
            return false;
        }

        return deskTypes.contains(expectedDeskType);
    }

    public abstract String getTypeName();
}
