/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bcxin.tenant.open.domains.entities.RoomEntity;
import com.bcxin.tenant.open.domains.entities.RoomUserEntity;
import com.bcxin.tenant.open.domains.mappers.RoomMapper;
import com.bcxin.tenant.open.domains.mappers.RoomUserMapper;
import com.bcxin.tenant.open.domains.repositories.RoomRepository;
import com.bcxin.tenant.open.infrastructures.enums.ProcessedStatus;
import com.bcxin.tenant.open.infrastructures.enums.RoomUserStatus;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;

@Repository
public class RoomRepositoryImpl
implements RoomRepository {
    private final RoomMapper roomMapper;
    private final RoomUserMapper roomUserMapper;

    public RoomRepositoryImpl(RoomMapper roomMapper, RoomUserMapper roomUserMapper) {
        this.roomMapper = roomMapper;
        this.roomUserMapper = roomUserMapper;
    }

    public RoomEntity getById(Object id) {
        return null;
    }

    public void update(RoomEntity data) {
    }

    public void insert(RoomEntity room) {
        this.roomMapper.customInsert(room);
    }

    public Collection<Long> getReadyForCalculatedRoomIds(int pageSize) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(RoomEntity::getTencentClosed, (Object)true);
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(RoomEntity::getStatus, (Object)ProcessedStatus.Init.ordinal());
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.last(String.format("limit 0,%s", pageSize));
        lambdaQueryWrapper = lambdaQueryWrapper.select(new SFunction[]{RoomEntity::getId});
        List maps = this.roomMapper.selectMaps((Wrapper)lambdaQueryWrapper);
        return maps.stream().map(ii -> (Long)ii.get("id")).collect(Collectors.toList());
    }

    public void addRoomUsers(Collection<RoomUserEntity> users) {
        this.roomMapper.addUsers(users);
    }

    public Collection<RoomUserEntity> getRoomUsersByRoomIds(Collection<String> roomIds) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.in(RoomUserEntity::getRoomId, roomIds);
        return this.roomUserMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    public void removeUsers(long roomId, Collection<String> tencentUserIds) {
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        lambdaUpdateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)lambdaUpdateWrapper.set(RoomUserEntity::getStatus, (Object)RoomUserStatus.REMOVE.ordinal())).set(RoomUserEntity::getLeaveTime, (Object)Timestamp.from(Instant.now()))).eq(RoomUserEntity::getRoomId, (Object)roomId)).in(RoomUserEntity::getTencentUserId, tencentUserIds);
        this.roomUserMapper.update(null, (Wrapper)lambdaUpdateWrapper);
    }
}

