/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.open.domains.criterias.CompanyAdvanceCriteria;
import com.bcxin.tenant.open.domains.criterias.RdCompanyCriteria;
import com.bcxin.tenant.open.domains.dtos.CompanyAdvanceDTO;
import com.bcxin.tenant.open.domains.entities.RdCompanyEntity;
import com.bcxin.tenant.open.domains.mappers.RdCompanyMapper;
import com.bcxin.tenant.open.domains.repositories.RdCompanyRepository;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class RdCompanyRepositoryImpl
implements RdCompanyRepository {
    private final RdCompanyMapper rdCompanyMapper;

    public RdCompanyRepositoryImpl(RdCompanyMapper rdCompanyMapper) {
        this.rdCompanyMapper = rdCompanyMapper;
    }

    public RdCompanyEntity getById(Object id) {
        return (RdCompanyEntity)this.rdCompanyMapper.selectById((Long)id);
    }

    public void insert(RdCompanyEntity data) {
        this.rdCompanyMapper.insert(data);
    }

    public void update(RdCompanyEntity data) {
        this.rdCompanyMapper.updateById(data);
    }

    public Collection<RdCompanyEntity> find(RdCompanyCriteria criteria) {
        return null;
    }

    public Collection<RdCompanyEntity> getByPage(Collection<String> ids, int pageIndex, int pageSize) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (pageIndex <= 0) {
            pageIndex = 1;
        }
        if (!CollectionUtils.isEmpty(ids)) {
            wrapper = (LambdaQueryWrapper)wrapper.in(RdCompanyEntity::getId, ids);
        }
        Page page = new Page((long)pageIndex, (long)pageSize);
        IPage companyEntityPage = this.rdCompanyMapper.selectPage((IPage)page, (Wrapper)wrapper);
        return companyEntityPage.getRecords();
    }

    public RdCompanyEntity getByNoPkId(String id) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(RdCompanyEntity::getId, (Object)id);
        return (RdCompanyEntity)this.rdCompanyMapper.selectOne((Wrapper)lambdaQueryWrapper);
    }

    public Collection<String> getCompanyIds(int pageIndex, int pageSize) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = lambdaQueryWrapper.select(new SFunction[]{RdCompanyEntity::getId});
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.last(String.format("limit %s,%s", (pageIndex - 1) * pageSize, pageSize));
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.orderByDesc(RdCompanyEntity::getPkId);
        List maps = this.rdCompanyMapper.selectMaps((Wrapper)lambdaQueryWrapper);
        return maps.stream().map(ii -> String.valueOf(ii.get("id"))).collect(Collectors.toList());
    }

    public EntityCollection<CompanyAdvanceDTO> findByStations(CompanyAdvanceCriteria criteria) {
        Collection<CompanyAdvanceDTO> data = this.rdCompanyMapper.find(criteria);
        long totalCount = this.rdCompanyMapper.count(criteria);
        return EntityCollection.create(data, (int)criteria.getPageSize(), (Long)totalCount);
    }

    public List<String> selectAllCompanyIds() {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = lambdaQueryWrapper.select(new SFunction[]{RdCompanyEntity::getId});
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.orderByDesc(RdCompanyEntity::getPkId);
        List maps = this.rdCompanyMapper.selectMaps((Wrapper)lambdaQueryWrapper);
        return maps.stream().map(ii -> String.valueOf(ii.get("id"))).collect(Collectors.toList());
    }
}

