/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import org.springframework.data.annotation.Id;

@Document(language=SearchLanguage.CHINESE, timeToLive=300L)
public class RollCallProgressStatusDocument
extends EntityAbstract {
    @Id
    @Indexed
    private Long id;
    private int countOfMembers;
    private int countOfProcessed;

    public static RollCallProgressStatusDocument create(Long id, int countOfMembers) {
        RollCallProgressStatusDocument document = new RollCallProgressStatusDocument();
        document.setId(id);
        document.setCountOfMembers(countOfMembers);
        document.setCountOfProcessed(0);
        return document;
    }

    public void incrProcessed(int count) {
        this.setCountOfProcessed(this.getCountOfProcessed() + count);
    }

    public Long getId() {
        return this.id;
    }

    public int getCountOfMembers() {
        return this.countOfMembers;
    }

    public int getCountOfProcessed() {
        return this.countOfProcessed;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCountOfMembers(int countOfMembers) {
        this.countOfMembers = countOfMembers;
    }

    public void setCountOfProcessed(int countOfProcessed) {
        this.countOfProcessed = countOfProcessed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RollCallProgressStatusDocument)) {
            return false;
        }
        RollCallProgressStatusDocument other = (RollCallProgressStatusDocument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCountOfMembers() != other.getCountOfMembers()) {
            return false;
        }
        if (this.getCountOfProcessed() != other.getCountOfProcessed()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RollCallProgressStatusDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCountOfMembers();
        result = result * 59 + this.getCountOfProcessed();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    public String toString() {
        return "RollCallProgressStatusDocument(id=" + this.getId() + ", countOfMembers=" + this.getCountOfMembers() + ", countOfProcessed=" + this.getCountOfProcessed() + ")";
    }
}

