/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

@Schema(name="MyDispatchLogRecordResponse", title="\u6211\u7684\u70b9\u540d\u8bb0\u5f55")
public class MyDispatchLogRecordResponse
extends ResponseAbstract {
    private final String id;
    @Schema(name="callerName", title="\u8c03\u5ea6\u65b9\uff08\u4eba\uff09")
    private final String callerName;
    @Schema(name="callerCompanyName", title="\u8c03\u5ea6\u65b9")
    private final String callerCompanyName;
    @Schema(name="communicatedTypeLabel", title="\u8c03\u5ea6\u65b9\u5f0f")
    private final String communicatedTypeLabel;
    @Schema(name="beginTime", title="\u88ab\u8c03\u5ea6\u5f00\u59cb\u65f6\u95f4")
    private final String beginTime;
    @Schema(name="endTime", title="\u88ab\u8c03\u5ea6\u7ed3\u675f\u65f6\u95f4")
    private final String endTime;
    @Schema(name="dispatchTime", title="\u8c03\u5ea6\u65f6\u957f")
    private final int dispatchTime;
    @Schema(name="createdTime", title="\u6807\u9898\u4e0a\u7684\u65e5\u671f")
    private final String createdTime;

    public MyDispatchLogRecordResponse(String id, String callerName, String callerCompanyName, CommunicatedType communicatedType, Timestamp beginTime, Timestamp endTime, int dispatchTime, Timestamp createdTime) {
        this.id = id;
        this.callerName = callerName;
        this.callerCompanyName = callerCompanyName;
        this.communicatedTypeLabel = communicatedType.getTypeName();
        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        this.beginTime = beginTime != null ? timeFormat.format(beginTime) : "-";
        this.endTime = endTime != null ? timeFormat.format(endTime) : "-";
        this.dispatchTime = dispatchTime;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        this.createdTime = dateFormat.format(createdTime);
    }

    public static MyDispatchLogRecordResponse create(String id, String callerName, String callerCompanyName, CommunicatedType communicatedType, Timestamp beginTime, Timestamp endTime, int dispatchTime, Timestamp createdTime) {
        return new MyDispatchLogRecordResponse(id, callerName, callerCompanyName, communicatedType, beginTime, endTime, dispatchTime, createdTime);
    }

    public String getId() {
        return this.id;
    }

    public String getCallerName() {
        return this.callerName;
    }

    public String getCallerCompanyName() {
        return this.callerCompanyName;
    }

    public String getCommunicatedTypeLabel() {
        return this.communicatedTypeLabel;
    }

    public String getBeginTime() {
        return this.beginTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public int getDispatchTime() {
        return this.dispatchTime;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }
}

