/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.configs;

import com.bcxin.backend.domain.baoans.models.DocumentDTO;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableJpaRepositories(basePackages={"com.bcxin.backend.domain.baoans.repositories"}, entityManagerFactoryRef="baoanEntityManagerFactory", transactionManagerRef="baoanTransactionManager")
public class BaoanDomainConfig {
    @Bean(value={"baoanDataSourceProperties"})
    @ConfigurationProperties(value="spring.datasource.baoan")
    public DataSourceProperties baoanDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean(value={"baoanDataSource"})
    public DataSource baoanDataSource() {
        return this.baoanDataSourceProperties().initializeDataSourceBuilder().build();
    }

    @Bean(name={"baoanEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean baoanEntityManagerFactory(EntityManagerFactoryBuilder builder) {
        return builder.dataSource(this.baoanDataSource()).packages(new Class[]{DocumentDTO.class}).build();
    }

    @Bean(value={"baoanTransactionManager"})
    public PlatformTransactionManager baoanTransactionManager(@Qualifier(value="baoanEntityManagerFactory") LocalContainerEntityManagerFactoryBean baoanEntityManagerFactory) {
        return new JpaTransactionManager(baoanEntityManagerFactory.getObject());
    }
}

