package com.bcxin.backend.certificateSignatures.impls.values;

import lombok.Getter;

@Getter
public class SignaturePdfResult {
    private final boolean ignored;
    private final String result;
    private final String message;

    public SignaturePdfResult(boolean ignored,String result, String message) {
        this.result = result;
        this.message = message;
        this.ignored = ignored;
    }

    public static SignaturePdfResult create(String result, String message) {
        return new SignaturePdfResult(false,result, message);
    }

    public static SignaturePdfResult createIgnoreResult(){
        return new SignaturePdfResult(true, null, null);
    }
}
