package com.bcxin.backend.jobs;

import com.bcxin.backend.tasks.TaskAbstract;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Collection;

@Component
@Slf4j
public class ScheduleJob extends ScheduleJobAbstract {
    private final static Logger logger = LoggerFactory.getLogger(ScheduleJob.class);


    /**
     * 每日定时推送宁夏归集数据(每日凌晨1触发) cron = "0 0 1 * * ?
     */
    @Scheduled(cron = "${myapps.nxgjApi.nxgjschedule}") //5分钟执行一次
    public void SecuritySeviceK() {
        logger.error("保安服务许可审批");
        Collection<TaskAbstract> taskAbstracts = this.getTasks("execute.SecuritySeviceK");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }

    /**
     * 获取并且执行所有APP的定时任务，并且缓存到本地
     */
    @Scheduled(fixedDelay = 3 * 60 * 1000) // 60秒执行一次  测试，可以改
    public void executeAppJob() {
        logger.info("获取并且执行所有APP的定时任务已开启");
        Collection<TaskAbstract> taskAbstracts = this.getTasks("execute.app.job");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }


    /**
     * 清除本地的APP信息缓存
     */

    @Scheduled(fixedDelay = 24 * 60 * 60 * 1000) // 一小时执行一次  测试，可以改  时间别跟 获取缓存时间成整数倍
    public void executeCleanAppJob() {
        logger.info("清除本地的APP信息缓存已开启");
        Collection<TaskAbstract> taskAbstracts = this.getTasks("execute.clean.app.job");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }

    //实名认证每20分钟执行一次 测试环境1分钟一次
    @Scheduled(cron = "${myapps.authentication.timing}")
    public void authentication() {
        Collection<TaskAbstract> taskAbstracts = this.getTasks("execute.RealName.authentication");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }

    @Scheduled(cron = "${myapps.message.send}")
    public void sendMessage() {
        Collection<TaskAbstract> taskAbstracts = this.getTasks("message.send");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }

    /**
     * 30分钟执行一次
     */
    @Scheduled(fixedDelay = 30 * 60 * 1000)
    public void notifyOverDueAuditors() {
        Collection<TaskAbstract> taskAbstracts = this.getTasks("overDue.notice");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }





    /**
     * 每日定时清除map缓存queuesId数据(每日凌晨两点执行一次) cron = "0 0 2 * * ?
     */
    @Scheduled(cron = "0 0 2 * * ?")
    public void cleanQueuesCache() {
        Collection<TaskAbstract> taskAbstracts = this.getTasks("sync.clean.queues.cache");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }
    
    /**
     * 每日定时推送北京许可备案数据给治总（每天凌晨3点）
     */
    @Scheduled(cron = "${myapps.bj-approval-data-push.schedule.daily}")
    public void bjApprovalDatePush() {
        Collection<TaskAbstract> taskAbstracts = this.getTasks("push.bj.approval.data.task.daily");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }
    /**
     * 每周定时推送过去一周时间内的北京许可备案数据给治总（每周日晚上10点），用于补偿推送失败
     */
    @Scheduled(cron = "${myapps.bj-approval-data-push.schedule.weekly}")
    public void bjApprovalDatePushWeekly() {
        Collection<TaskAbstract> taskAbstracts = this.getTasks("push.bj.approval.data.task.weekly");
        taskAbstracts.forEach(task -> {
            task.run();
        });
    }
}
