package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.screening.service.TimingBackgroundScreeningService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix = "myapps.screeninng",name = "enable",havingValue = "true")
public class TimingBackgroundScreeningTask extends TaskAbstract{

    private final TimingBackgroundScreeningService backgroundScreeningService;

    public TimingBackgroundScreeningTask(TimingBackgroundScreeningService backgroundScreeningService) {

        this.backgroundScreeningService = backgroundScreeningService;
    }


    @Override
    protected void runCore() throws Exception {
        backgroundScreeningService.screening();
    }

    @Override
    public String getTaskName() {
        return "execute.Screening.job.timing";
    }


}
